/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particle3DBuilder;
import fr.ens.transcriptome.corsen.model.Point3D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Particle3DUtil {
    private static MapCuboid initCuboids(Particle3D particle, float xlenght, float ylenght, float zlenght) {
        AbstractListPoint3D lp = particle.getInnerPoints();
        MapCuboid mapCuboid = new MapCuboid();
        double xMax = lp.getXMax() + xlenght;
        double yMax = lp.getYMax() + ylenght;
        double zMax = lp.getZMax() + zlenght;
        double xMin = Math.floor(lp.getXMin() / xlenght) * (double)xlenght;
        double yMin = (float)(Math.floor(lp.getYMin() / ylenght) * (double)ylenght);
        double zMin = (float)(Math.floor(lp.getZMin() / zlenght) * (double)zlenght);
        for (double i = xMin; i < xMax; i += (double)xlenght) {
            for (double j = yMin; j < yMax; j += (double)ylenght) {
                for (double k = zMin; k < zMax; k += (double)zlenght) {
                    int x = (int)(i / (double)xlenght);
                    int y = (int)(j / (double)ylenght);
                    int z = (int)(k / (double)zlenght);
                    double x1 = i + (double)xlenght;
                    double y1 = j + (double)ylenght;
                    double z1 = k + (double)zlenght;
                    Particle3DBuilder builder = new Particle3DBuilder(particle.getPixelWidth(), particle.getPixelHeight(), particle.getPixelDepth());
                    builder.setName(particle.getName() + "-" + builder.getId());
                    builder.setComment("Cuboid from Particle #" + particle.getId());
                    Particle3DUtil.addSurfacePoint(builder, i, j, k);
                    Particle3DUtil.addSurfacePoint(builder, x1, j, k);
                    Particle3DUtil.addSurfacePoint(builder, x1, y1, k);
                    Particle3DUtil.addSurfacePoint(builder, i, y1, k);
                    Particle3DUtil.addSurfacePoint(builder, i, j, z1);
                    Particle3DUtil.addSurfacePoint(builder, x1, j, z1);
                    Particle3DUtil.addSurfacePoint(builder, x1, y1, z1);
                    Particle3DUtil.addSurfacePoint(builder, i, y1, z1);
                    mapCuboid.put(x, y, z, builder);
                }
            }
        }
        return mapCuboid;
    }

    private static void addSurfacePoint(Particle3DBuilder builder, double x, double y, double z) {
        builder.addSurfacePoint((float)x, (float)y, (float)z, 0);
    }

    private static void fillCuboids(Particle3D particle, MapCuboid mapCuboids, float xlenght, float ylenght, float zlenght) {
        AbstractListPoint3D points = particle.getInnerPoints();
        int n = points.size();
        for (int i = 0; i < n; ++i) {
            float x = points.getXAt(i);
            float y = points.getYAt(i);
            float z = points.getZAt(i);
            Integer xMapIndex = (int)(x / xlenght);
            Integer yMapIndex = (int)(y / ylenght);
            Integer zMapIndex = (int)(z / zlenght);
            Particle3DBuilder builder = mapCuboids.get(xMapIndex, yMapIndex, zMapIndex);
            builder.addInnerPoint(x, y, z, points.getIAt(i));
        }
    }

    public static List<Particle3D> createCuboidToArrayList(Particle3D particle, float xlenght, float ylenght, float zlenght) {
        if (particle == null) {
            throw new NullPointerException("Particle is null");
        }
        MapCuboid mapCuboids = Particle3DUtil.initCuboids(particle, xlenght, ylenght, zlenght);
        Particle3DUtil.fillCuboids(particle, mapCuboids, xlenght, ylenght, zlenght);
        ArrayList<Particle3D> cuboidArrayList = null;
        for (Object keyX : mapCuboids.keySet()) {
            Map mapY = (Map)mapCuboids.get(keyX);
            for (Object keyY : mapY.keySet()) {
                Map mapZ = (Map)mapY.get(keyY);
                for (Object keyZ : mapZ.keySet()) {
                    Particle3DBuilder builder = (Particle3DBuilder)mapZ.get(keyZ);
                    if (builder.innerPointsCount() <= 0) continue;
                    if (cuboidArrayList == null) {
                        cuboidArrayList = new ArrayList<Particle3D>();
                    }
                    cuboidArrayList.add(builder.getParticle());
                }
            }
        }
        return cuboidArrayList;
    }

    public static Map<String, Particle3D> createCuboidToMap(Particle3D particle, float xlenght, float ylenght, float zlenght) {
        if (particle == null) {
            throw new NullPointerException("Particle is null");
        }
        MapCuboid mapCuboids = Particle3DUtil.initCuboids(particle, xlenght, ylenght, zlenght);
        Particle3DUtil.fillCuboids(particle, mapCuboids, xlenght, ylenght, zlenght);
        HashMap<String, Particle3D> result = null;
        for (Object keyX : mapCuboids.keySet()) {
            Map mapY = (Map)mapCuboids.get(keyX);
            for (Object keyY : mapY.keySet()) {
                Map mapZ = (Map)mapY.get(keyY);
                for (Object keyZ : mapZ.keySet()) {
                    Particle3D p = ((Particle3DBuilder)mapZ.get(keyZ)).getParticle();
                    if (p.innerPointsCount() <= 0) continue;
                    if (result == null) {
                        result = new HashMap<String, Particle3D>();
                    }
                    result.put("" + keyX + "," + keyY + "," + keyZ, p);
                }
            }
        }
        return result;
    }

    public static int countInnerPointsInParticles(List<Particle3D> particles) {
        if (particles == null) {
            return 0;
        }
        int count = 0;
        for (Particle3D par : particles) {
            count += par.innerPointsCount();
        }
        return count;
    }

    public static Particle3D createBarycentreParticle3D(Particle3D particle, Particle3DBuilder builder) {
        if (particle == null || builder == null) {
            return null;
        }
        Point3D barycentre = particle.getInnerPoints().getBarycenter();
        builder.addInnerPoint(barycentre);
        builder.addSurfacePoint(barycentre);
        return builder.getParticle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapCuboid
    extends HashMap<Integer, Map<Integer, Map<Integer, Particle3DBuilder>>> {
        private MapCuboid() {
        }

        public void put(int xMapIndex, int yMapIndex, int zMapIndex, Particle3DBuilder particleBuilder) {
            HashMap<Integer, Particle3DBuilder> mapZ;
            HashMap<Integer, HashMap<Integer, Particle3DBuilder>> mapY = (HashMap<Integer, HashMap<Integer, Particle3DBuilder>>)this.get(xMapIndex);
            if (mapY == null) {
                mapY = new HashMap<Integer, HashMap<Integer, Particle3DBuilder>>();
                this.put(xMapIndex, mapY);
            }
            if ((mapZ = (HashMap<Integer, Particle3DBuilder>)mapY.get(yMapIndex)) == null) {
                mapZ = new HashMap<Integer, Particle3DBuilder>();
                mapY.put(yMapIndex, mapZ);
            }
            mapZ.put(zMapIndex, particleBuilder);
        }

        public Particle3DBuilder get(int xMapIndex, int yMapIndex, int zMapIndex) {
            Map mapY = (Map)this.get(xMapIndex);
            Map mapZ = (Map)mapY.get(yMapIndex);
            return (Particle3DBuilder)mapZ.get(zMapIndex);
        }
    }
}

