/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.Globals;
import fr.ens.transcriptome.corsen.calc.ParticleType;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particle3DBuilder;
import fr.ens.transcriptome.corsen.model.Particles3DFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Particles3D {
    private static final String PAR_FILE_VERSION = "1.4";
    public static final String PAR_FILE_VERSION_KEY = "ParFileVersion";
    public static final String WIDTH_KEY = "Width";
    public static final String HEIGHT_KEY = "Height";
    public static final String ZSLICES_KEY = "ZSlices";
    public static final String PIXEL_WIDTH_KEY = "PixelWidth";
    public static final String PIXEL_HEIGHT_KEY = "PixelHeight";
    public static final String PIXEL_DEPTH_KEY = "PixelDepth";
    public static final String UNIT_OF_LENGHT_KEY = "UnitOfLength";
    public static final String MIN_THRESHOLD_KEY = "MinThreshold";
    public static final String MAX_THRESHOLD_KEY = "MaxThreshold";
    public static final String IMAGEFILE_KEY = "Image file name";
    private int width;
    private int height;
    private int zSlices;
    private float pixelWidth = 1.0f;
    private float pixelHeight = 1.0f;
    private float pixelDepth = 1.0f;
    private String unitOfLength = "";
    private double minThreshold;
    private double maxThreshold;
    private String name;
    private ParticleType type;
    private String imageFilename;
    private Date imageFilenameDate;
    private List<Particle3D> particles;

    public int getHeight() {
        return this.height;
    }

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public float getPixelDepth() {
        return this.pixelDepth;
    }

    public float getPixelHeight() {
        return this.pixelHeight;
    }

    public float getPixelWidth() {
        return this.pixelWidth;
    }

    public String getUnitOfLength() {
        return this.unitOfLength;
    }

    public int getWidth() {
        return this.width;
    }

    public int getZSlices() {
        return this.zSlices;
    }

    public List<Particle3D> getParticles() {
        return this.particles;
    }

    public ParticleType getType() {
        return this.type;
    }

    public Date getImageFilenameDate() {
        return this.imageFilenameDate == null ? null : (Date)this.imageFilenameDate.clone();
    }

    public String getName() {
        return this.name;
    }

    public void setParticles(Particle3D[] particles) {
        if (particles == null) {
            throw new NullPointerException("Particles to set is null");
        }
        this.setParticles(Arrays.asList(particles));
    }

    public void setParticles(List<Particle3D> particles) {
        if (particles == null) {
            throw new NullPointerException("Particles to set is null");
        }
        this.particles = Collections.unmodifiableList(particles);
    }

    public void setType(ParticleType type) {
        this.type = type;
    }

    public String getImageFilename() {
        return this.imageFilename;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setZSlices(int slices) {
        this.zSlices = slices;
    }

    public void setPixelWidth(float pixelWidth) {
        this.pixelWidth = pixelWidth;
    }

    public void setPixelHeight(float pixelHeight) {
        this.pixelHeight = pixelHeight;
    }

    public void setPixelDepth(float pixelDepth) {
        this.pixelDepth = pixelDepth;
    }

    public void setUnitOfLength(String unitOfLength) {
        this.unitOfLength = unitOfLength;
    }

    public void setMinThreshold(double minThreshold) {
        this.minThreshold = minThreshold;
    }

    public void setMaxThreshold(double maxThreshold) {
        this.maxThreshold = maxThreshold;
    }

    public void setImageFilename(String imageFilename) {
        this.imageFilename = imageFilename;
    }

    public void setImageFilenameDate(Date imageFilenameDate) {
        this.imageFilenameDate = imageFilenameDate == null ? null : (Date)imageFilenameDate.clone();
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name;
    }

    public boolean isSameDimensionSpace(Particles3D pars) {
        if (pars == null) {
            return false;
        }
        return pars.width == this.width && pars.height == this.height && pars.zSlices == this.zSlices && pars.pixelWidth == this.pixelWidth && pars.pixelHeight == this.pixelHeight && pars.pixelDepth == this.pixelDepth;
    }

    private void readParticles(InputStream is) throws IOException {
        String line;
        if (is == null) {
            throw new NullPointerException("The stream is null");
        }
        ArrayList<Particle3D> particles = new ArrayList<Particle3D>();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        int parVersion = -1;
        boolean header = true;
        while ((line = in.readLine()) != null) {
            if (line.startsWith("# Image file name")) {
                this.imageFilename = line;
                continue;
            }
            if (line.startsWith("#")) continue;
            if (header) {
                String[] ch;
                if (line.startsWith("Name\t")) {
                    header = false;
                    if (parVersion >= 3) continue;
                    throw new IOException("Can't read an old Par file format.");
                }
                if (line.startsWith("Dimension")) {
                    ch = line.split("\t");
                    if (ch.length != 4) {
                        throw new RuntimeException("Invalid input file (Bad dimension field).");
                    }
                    this.width = (int)Float.parseFloat(ch[1].trim());
                    this.height = (int)Float.parseFloat(ch[2].trim());
                    this.zSlices = (int)Float.parseFloat(ch[3].trim());
                    continue;
                }
                ch = line.split("=");
                if (ch.length != 2) continue;
                String key = ch[0].trim();
                String value = ch[1].trim();
                if (WIDTH_KEY.endsWith(key)) {
                    this.width = Integer.parseInt(value.trim());
                    continue;
                }
                if (HEIGHT_KEY.endsWith(key)) {
                    this.height = Integer.parseInt(value.trim());
                    continue;
                }
                if (ZSLICES_KEY.endsWith(key)) {
                    this.zSlices = Integer.parseInt(value.trim());
                    continue;
                }
                if (PIXEL_WIDTH_KEY.endsWith(key)) {
                    this.pixelWidth = Float.parseFloat(value.trim());
                    continue;
                }
                if (PIXEL_HEIGHT_KEY.endsWith(key)) {
                    this.pixelHeight = Float.parseFloat(value.trim());
                    continue;
                }
                if (PIXEL_DEPTH_KEY.endsWith(key)) {
                    this.pixelDepth = Float.parseFloat(value.trim());
                    continue;
                }
                if (UNIT_OF_LENGHT_KEY.endsWith(key)) {
                    this.unitOfLength = value.trim();
                    continue;
                }
                if (MIN_THRESHOLD_KEY.endsWith(key)) {
                    this.minThreshold = Double.parseDouble(value.trim());
                    continue;
                }
                if (MAX_THRESHOLD_KEY.endsWith(key)) {
                    this.maxThreshold = Double.parseDouble(value.trim());
                    continue;
                }
                if (IMAGEFILE_KEY.endsWith(key)) {
                    this.imageFilename = value.trim();
                    continue;
                }
                if (!PAR_FILE_VERSION_KEY.endsWith(key)) continue;
                parVersion = Integer.parseInt(value.substring(value.indexOf(".") + 1).trim());
                continue;
            }
            particles.add(new Particle3DBuilder(this.pixelWidth, this.pixelHeight, this.pixelDepth, line, parVersion).getParticle());
        }
        in.close();
        this.setParticles(particles);
    }

    public void changeZCoord(float zCoef) {
        if (zCoef == 1.0f) {
            return;
        }
        for (Particle3D par : this.particles) {
            this.changeZCoord(par, zCoef);
        }
        this.pixelDepth *= zCoef;
    }

    private void changeZCoord(Particle3D particle, float zCoef) {
        if (particle == null || zCoef == 1.0f) {
            return;
        }
        particle.applyZFactor(zCoef);
    }

    public void changeAllCoord(float coef) {
        if (coef == 1.0f) {
            return;
        }
        for (Particle3D par : this.particles) {
            this.changeCoord(par, coef);
        }
        this.pixelWidth *= coef;
        this.pixelHeight *= coef;
        this.pixelDepth *= coef;
    }

    private void changeCoord(Particle3D particle, float coef) {
        if (particle == null) {
            return;
        }
        particle.applyXFactor(coef);
        particle.applyYFactor(coef);
        particle.applyZFactor(coef);
    }

    public int countParticlesInnerPoints() {
        if (this.particles == null) {
            return 0;
        }
        int result = 0;
        for (Particle3D par : this.getParticles()) {
            result += par.getInnerPoints().size();
        }
        return result;
    }

    public int countParticlesSurfacePoints() {
        if (this.particles == null) {
            return 0;
        }
        int result = 0;
        for (Particle3D par : this.getParticles()) {
            result += par.getSurfacePoints().size();
        }
        return result;
    }

    public void saveParticles(OutputStream outputStream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        writer.write("# Generated by ");
        writer.write("Corsen");
        writer.write(" version ");
        writer.write(Globals.APP_VERSION);
        writer.write(" (");
        writer.write(Globals.APP_BUILD_NUMBER);
        writer.write(", ");
        writer.write(Globals.APP_BUILD_DATE);
        writer.write(")");
        writer.write("\n# Generated on ");
        writer.write(new Date(System.currentTimeMillis()).toString());
        writer.write("\n# Image file name: ");
        writer.write(this.imageFilename != null ? this.imageFilename : "Unknown image file");
        writer.write("\n# Image created on ");
        writer.write(this.imageFilenameDate != null ? this.imageFilenameDate.toString() : "Unknown creation date");
        writer.write("\nParFileVersion=1.4");
        writer.write("\nWidth=" + this.width);
        writer.write("\nHeight=" + this.height);
        writer.write("\nZSlices=" + this.zSlices);
        writer.write("\nPixelWidth=" + this.pixelWidth);
        writer.write("\nPixelHeight=" + this.pixelHeight);
        writer.write("\nPixelDepth=" + this.pixelDepth);
        writer.write("\nUnitOfLength=" + this.unitOfLength);
        writer.write("\nMinThreshold=" + this.minThreshold);
        writer.write("\nMaxThreshold=" + this.maxThreshold);
        writer.write("\nName\tCenter\tBarycenter\tArea\tVolume\tSphericity\tIntensity\tDensity\tMedian Circularity\tSurface points\tInner points\n");
        if (this.particles != null) {
            for (Particle3D p : this.particles) {
                if (p.getIntensity() == 0L) continue;
                writer.write(p.toString());
                ((Writer)writer).write(10);
            }
        }
        ((Writer)writer).close();
    }

    public Particles3D filter(Particles3DFilter filter) {
        if (filter == null) {
            return this;
        }
        Particles3D result = new Particles3D(this);
        List<Particle3D> particles = this.getParticles();
        ArrayList<Particle3D> filteredParticles = new ArrayList<Particle3D>(particles.size());
        for (Particle3D p : particles) {
            if (!filter.accept(p)) continue;
            filteredParticles.add(p);
        }
        filteredParticles.trimToSize();
        result.setName(this.getName());
        result.setParticles(filteredParticles);
        return result;
    }

    public int getInnerPointCount() {
        if (this.particles == null) {
            return 0;
        }
        int count = 0;
        for (Particle3D p : this.particles) {
            count += p.innerPointsCount();
        }
        return count;
    }

    public int getSurfacePointCount() {
        if (this.particles == null) {
            return 0;
        }
        int count = 0;
        for (Particle3D p : this.particles) {
            count += p.surfacePointsCount();
        }
        return count;
    }

    public String toString() {
        return "Particles=" + this.particles;
    }

    public Particles3D(Particles3D pars) {
        this.width = pars.width;
        this.height = pars.height;
        this.zSlices = pars.zSlices;
        this.pixelWidth = pars.pixelWidth;
        this.pixelHeight = pars.pixelHeight;
        this.pixelDepth = pars.pixelDepth;
        this.unitOfLength = pars.unitOfLength;
        this.minThreshold = pars.minThreshold;
        this.maxThreshold = pars.maxThreshold;
    }

    public Particles3D(Particles3D pars, Particle3D[] particles) {
        this(pars);
        this.setParticles(particles);
    }

    public Particles3D(Particles3D pars, List<Particle3D> particles) {
        this(pars);
        this.setParticles(particles);
    }

    public Particles3D(InputStream is) throws IOException {
        this.readParticles(is);
    }

    public Particles3D(File file) throws IOException {
        this.readParticles(new FileInputStream(file));
    }

    public Particles3D() {
    }
}

