/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.SimplePoint2DImpl;
import java.util.StringTokenizer;

public abstract class Point2D {
    public abstract float getX();

    public abstract float getY();

    public abstract int getI();

    public abstract void setX(float var1);

    public abstract void setY(float var1);

    public abstract void setI(int var1);

    public final float distance(Point2D p) {
        float dx = this.getX() - p.getX();
        float dy = this.getY() - p.getY();
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getX());
        sb.append(',');
        sb.append(this.getY());
        sb.append(',');
        sb.append(this.getI());
        return sb.toString();
    }

    public static Point2D parse(String s) {
        if (s == null) {
            return null;
        }
        SimplePoint2DImpl p = new SimplePoint2DImpl();
        StringTokenizer st = new StringTokenizer(s, ",");
        if (st.hasMoreElements()) {
            ((Point2D)p).setX(Float.parseFloat(st.nextToken()));
        }
        if (st.hasMoreElements()) {
            ((Point2D)p).setY(Float.parseFloat(st.nextToken()));
        }
        if (st.hasMoreElements()) {
            ((Point2D)p).setI(Integer.parseInt(st.nextToken()));
        }
        return p;
    }

    public boolean isSamePosition(Point2D point) {
        if (point == null) {
            return false;
        }
        return this.getX() == point.getX() && this.getY() == point.getY();
    }
}

