/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.SimplePoint3DImpl;
import java.util.StringTokenizer;

public abstract class Point3D
implements Comparable {
    public abstract float getX();

    public abstract float getY();

    public abstract float getZ();

    public abstract int getI();

    public abstract void setX(float var1);

    public abstract void setY(float var1);

    public abstract void setZ(float var1);

    public abstract void setI(int var1);

    public final float distance(Point3D p) {
        if (p == null) {
            return -1.0f;
        }
        double dx = this.getX() - p.getX();
        double dy = this.getY() - p.getY();
        double dz = this.getZ() - p.getZ();
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public final boolean isNear(Point3D p, float maxDistance) {
        if (p == null || maxDistance < 0.0f) {
            return false;
        }
        float d = this.distance(p);
        return d < maxDistance;
    }

    public final boolean isNear(Point3D p, float xlen, float ylen, float zlen) {
        if (p == null || xlen < 0.0f || ylen < 0.0f || zlen < 0.0f) {
            return false;
        }
        return Math.abs(this.getX() - p.getX()) < xlen && Math.abs(this.getY() - p.getY()) < ylen && Math.abs(this.getZ() - p.getZ()) < zlen;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getX());
        sb.append(',');
        sb.append(this.getY());
        sb.append(',');
        sb.append(this.getZ());
        sb.append(',');
        sb.append(this.getI());
        return sb.toString();
    }

    public String toStringWithoutIntensity() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getX());
        sb.append(',');
        sb.append(this.getY());
        sb.append(',');
        sb.append(this.getZ());
        return sb.toString();
    }

    public static Point3D parse(String s) {
        if (s == null) {
            return null;
        }
        SimplePoint3DImpl p = new SimplePoint3DImpl();
        StringTokenizer st = new StringTokenizer(s, ",");
        if (st.hasMoreElements()) {
            ((Point3D)p).setX(Float.parseFloat(st.nextToken()));
        }
        if (st.hasMoreElements()) {
            ((Point3D)p).setY(Float.parseFloat(st.nextToken()));
        }
        if (st.hasMoreElements()) {
            ((Point3D)p).setZ(Float.parseFloat(st.nextToken()));
        }
        if (st.hasMoreElements()) {
            ((Point3D)p).setI(Short.parseShort(st.nextToken()));
        }
        return p;
    }

    public boolean equals(Object point) {
        if (!(point instanceof Point3D)) {
            return false;
        }
        Point3D p = (Point3D)point;
        return p.getX() == this.getX() && p.getY() == this.getY() && p.getZ() == this.getZ();
    }

    public int compareTo(Object point) {
        return this.compareTo((Point3D)point);
    }

    public int compareTo(Point3D point) {
        if (point == null) {
            throw new NullPointerException();
        }
        float diffX = this.getX() - point.getX();
        if (diffX != 0.0f) {
            return diffX < 0.0f ? -1 : 1;
        }
        float diffY = this.getY() - point.getY();
        if (diffY != 0.0f) {
            return diffY < 0.0f ? -1 : 1;
        }
        float diffZ = this.getZ() - point.getZ();
        if (diffZ != 0.0f) {
            return diffZ < 0.0f ? -1 : 1;
        }
        float diffI = this.getI() - point.getI();
        if (diffI < 0.0f) {
            return -1;
        }
        if (diffI == 0.0f) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        int iTotal = 17;
        int iConstant = 37;
        iTotal = iTotal * 37 + Float.floatToIntBits(this.getX());
        iTotal = iTotal * 37 + Float.floatToIntBits(this.getY());
        iTotal = iTotal * 37 + Float.floatToIntBits(this.getZ());
        iTotal = iTotal * 37 + this.getI();
        return 0;
    }
}

