/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.util;

public class MathUtil {
    public static final double roundValue(double value) {
        return MathUtil.roundValue(value, 1.0E-14);
    }

    public static final double roundValue(double value, double threshold) {
        double rInt = Math.rint(value);
        if (Math.abs(value - rInt) < threshold) {
            return rInt;
        }
        return value;
    }

    public static final float roundValue(float value) {
        return MathUtil.roundValue(value, 1.0E-5f);
    }

    public static final float roundValue(float value, float threshold) {
        float rInt = (float)Math.rint(value);
        if (Math.abs(value - rInt) < threshold) {
            return rInt;
        }
        return value;
    }

    public static final double sphericite1(double volume, double area) {
        return Math.PI * 4 * Math.pow(3.0 * volume / Math.PI * 4.0, 0.6666666666666666) / area;
    }

    public static final double sphericite2(double volume, double area) {
        return 6.0 * Math.sqrt(Math.PI) * volume / Math.pow(area, 1.5);
    }

    public static final double sphericite3(double volume, double area) {
        return Math.pow(Math.PI, 0.3333333333333333) * Math.pow(6.0 * volume, 0.6666666666666666) / area;
    }
}

