/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.util;

import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MinMaxList<E extends Comparable>
extends AbstractList<E> {
    private E min;
    private E max;
    private int count = 0;

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.count == 2) {
            return index == 0 ? this.min : this.max;
        }
        if (this.min == null) {
            return this.max;
        }
        return this.min;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean add(E o) {
        if (o == null) {
            throw new NullPointerException("Object to add is null");
        }
        if (this.count == 2) {
            if (o.compareTo(this.min) < 0) {
                this.min = o;
                return true;
            }
            if (o.compareTo(this.max) > 0) {
                this.max = o;
            }
            return true;
        }
        if (this.count == 0) {
            this.min = o;
            this.count = 1;
            return true;
        }
        if (this.count == 1) {
            if (o.compareTo(this.min) < 0) {
                this.max = this.min;
                this.min = o;
            } else {
                this.max = o;
            }
            this.count = 2;
            return true;
        }
        throw new IllegalStateException("The object can't have " + this.count + " values");
    }

    @Override
    public void add(int index, E element) {
        this.add(element);
    }

    @Override
    public void clear() {
        this.min = null;
        this.max = null;
        this.count = 0;
    }

    @Override
    public E remove(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            E result = this.min;
            this.min = null;
            --this.count;
            return result;
        }
        E result = this.max;
        this.max = null;
        --this.count;
        return result;
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            if (element.compareTo(this.min) < 0) {
                E result = this.min;
                this.min = element;
                return result;
            }
            return element;
        }
        if (element.compareTo(this.max) > 0) {
            E result = this.max;
            this.max = element;
            return result;
        }
        return element;
    }
}

