/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.util;

import fr.ens.transcriptome.corsen.util.HashCodeUtil;
import fr.ens.transcriptome.corsen.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Stats {
    private static final int getRealSize(List<DataDouble> values) {
        if (values == null) {
            return 0;
        }
        int count = 0;
        for (DataDouble d : values) {
            d.virtualIndexMin = count;
            count = (int)((long)count + d.intensity);
            d.virtualIndexMax = count - 1;
        }
        return count;
    }

    public static double[] toDouble(List<DataDouble> values) {
        if (values == null) {
            return null;
        }
        int count = 0;
        for (DataDouble data : values) {
            count = (int)((long)count + data.intensity);
        }
        double[] result = new double[count];
        int i = 0;
        for (DataDouble data : values) {
            double val = data.value;
            int j = 0;
            while ((long)j < data.intensity) {
                result[i++] = val;
                ++j;
            }
        }
        return result;
    }

    private static double getVirtualValue(List<DataDouble> values, int index) {
        for (DataDouble d : values) {
            if (!d.isVirtualIndex(index)) continue;
            return d.value;
        }
        return Double.NaN;
    }

    public static double percentile(List<DataDouble> values, double p) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        if (p > 100.0 || p <= 0.0) {
            throw new IllegalArgumentException("invalid quantile value: " + p);
        }
        if (values.size() == 0) {
            return Double.NaN;
        }
        ArrayList<DataDouble> valuesCopy = new ArrayList<DataDouble>(values);
        Collections.sort(valuesCopy);
        int length = Stats.getRealSize(valuesCopy);
        if (length == 1) {
            return ((DataDouble)valuesCopy.get((int)0)).value;
        }
        double n = length;
        double pos = p * (n + 1.0) / 100.0;
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        if (pos < 1.0) {
            return ((DataDouble)valuesCopy.get((int)0)).value;
        }
        if (pos >= n) {
            return ((DataDouble)valuesCopy.get((int)(length - 1))).value;
        }
        double lower = Stats.getVirtualValue(valuesCopy, intPos - 1);
        double upper = Stats.getVirtualValue(valuesCopy, intPos);
        return lower + dif * (upper - lower);
    }

    private static boolean test(double[] values, int begin, int length) {
        if (values == null) {
            throw new IllegalArgumentException("input value array is null");
        }
        if (begin < 0) {
            throw new IllegalArgumentException("start position cannot be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        if (begin + length > values.length) {
            throw new IllegalArgumentException("begin + length > values.length");
        }
        return length != 0;
    }

    public static double median(Collection<Double> values) {
        if (values == null) {
            return Double.NaN;
        }
        return Stats.median(Util.toArray(values));
    }

    public static double median(double[] values) {
        return Stats.percentile(values, 50.0);
    }

    public static double percentile(double[] values, double p) {
        if (values == null) {
            throw new IllegalArgumentException("values is null");
        }
        return Stats.percentile(values, 0, values.length, p);
    }

    private static double percentile(double[] values, int begin, int length, double p) {
        Stats.test(values, begin, length);
        if (p > 100.0 || p <= 0.0) {
            throw new IllegalArgumentException("invalid quantile value: " + p);
        }
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values[begin];
        }
        double n = length;
        double pos = p * (n + 1.0) / 100.0;
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        double[] sorted = new double[length];
        System.arraycopy(values, begin, sorted, 0, length);
        Arrays.sort(sorted);
        if (pos < 1.0) {
            return sorted[0];
        }
        if (pos >= n) {
            return sorted[length - 1];
        }
        double lower = sorted[intPos - 1];
        double upper = sorted[intPos];
        return lower + dif * (upper - lower);
    }

    public static double min(List<DataDouble> values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        if (values.size() == 0) {
            return Double.NaN;
        }
        DataDouble min = Collections.min(values);
        double minVal = Double.MAX_VALUE;
        for (DataDouble d : values) {
            if (!(d.value < minVal)) continue;
            minVal = d.value;
        }
        if (min.value != minVal) {
            System.err.println("not same!!");
        }
        return min.value;
    }

    public static double firstQuartile(List<DataDouble> values) {
        return Stats.percentile(values, 25.0);
    }

    public static double median(List<DataDouble> values) {
        return Stats.percentile(values, 50.0);
    }

    public static double mean(List<DataDouble> values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        int count = 0;
        float sum = 0.0f;
        for (DataDouble d : values) {
            count = (int)((long)count + d.intensity);
            sum = (float)((double)sum + (double)d.intensity * d.value);
        }
        return sum / (float)count;
    }

    public static double thirdQuartile(List<DataDouble> values) {
        return Stats.percentile(values, 75.0);
    }

    public static double max(List<DataDouble> values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        if (values.size() == 0) {
            return Double.NaN;
        }
        DataDouble max = Collections.max(values);
        return max.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DataDouble
    implements Comparable<DataDouble> {
        public double value;
        public long intensity;
        public int virtualIndexMin;
        public int virtualIndexMax;

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            DataDouble dd = (DataDouble)o;
            return dd.value == this.value;
        }

        @Override
        public final int compareTo(DataDouble d) {
            return Double.compare(this.value, d.value);
        }

        public final int hashCode() {
            int result = 23;
            result = HashCodeUtil.hash(result, this.value);
            result = HashCodeUtil.hash(result, this.intensity);
            result = HashCodeUtil.hash(result, this.virtualIndexMin);
            result = HashCodeUtil.hash(result, this.virtualIndexMax);
            return result;
        }

        public final boolean isVirtualIndex(int index) {
            return index >= this.virtualIndexMin && index <= this.virtualIndexMax;
        }

        public DataDouble(double value, long intensity) {
            this.value = value;
            this.intensity = intensity;
        }
    }
}

