/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.util;

import fr.ens.transcriptome.corsen.model.Point3D;
import java.io.File;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static final int MASK_16BITS = 65535;
    private static final long MASK_X = -65536L;
    private static final long MASK_Y = -4294901761L;
    private static final long MASK_Z = -281470681743361L;
    private static final long MASK_I = 0xFFFFFFFFFFFFL;
    private static final int SHIFT_X = 0;
    private static final int SHIFT_Y = 16;
    private static final int SHIFT_Z = 32;
    private static final int SHIFT_I = 48;

    public static final float getX(long point, float precision) {
        return (float)((point & 0xFFFFL) >> 0 & 0xFFFFL) / precision;
    }

    public static final float getY(long point, float precision) {
        return (float)((point & 0xFFFF0000L) >> 16 & 0xFFFFL) / precision;
    }

    public static final float getZ(long point, float precision) {
        return (float)((point & 0xFFFF00000000L) >> 32 & 0xFFFFL) / precision;
    }

    public static final int getI(long point) {
        return (int)((point & 0xFFFF000000000000L) >> 48 & 0xFFFFL);
    }

    public static final long setX(long point, float value, float precision) {
        if (!Util.isValueCorrect(value, precision)) {
            throw new RuntimeException("Invalid point value: This x value is too great or negative to be stored (" + value + ")");
        }
        long v = (long)(value * precision);
        return point & 0xFFFFFFFFFFFF0000L | (v & 0xFFFFL) << 0;
    }

    public static final long setY(long point, float value, float precision) {
        if (!Util.isValueCorrect(value, precision)) {
            throw new RuntimeException("Invalid point value: This y value is too great or negative to be stored (" + value + ")");
        }
        long v = (long)(value * precision);
        return point & 0xFFFFFFFF0000FFFFL | (v & 0xFFFFL) << 16;
    }

    public static final long setZ(long point, float value, float precision) {
        if (!Util.isValueCorrect(value, precision)) {
            throw new RuntimeException("Invalid point value: This z value is too great or negative to be stored (" + value + ")");
        }
        long v = (long)(value * precision);
        return point & 0xFFFF0000FFFFFFFFL | (v & 0xFFFFL) << 32;
    }

    public static final long setI(long point, int value) {
        if (!Util.isValueCorrect(value)) {
            throw new RuntimeException("Invalid point value: This i value is too great to be stored (" + value + ")");
        }
        return point & 0xFFFFFFFFFFFFL | ((long)value & 0xFFFFL) << 48;
    }

    public static final long valueWithoutI(long point) {
        return point & 0xFFFFFFFFFFFFL;
    }

    private static final boolean isValueCorrect(float value, float precision) {
        return value >= 0.0f && (double)value < Math.pow(2.0, 65535.0) / (double)precision;
    }

    private static final boolean isValueCorrect(int value) {
        return value >= 0 && (double)value < Math.pow(2.0, 65535.0);
    }

    public static final float getStoredMaxValue(float precision) {
        return 65535.0f / precision;
    }

    public static final int getStoredMaxValue() {
        return 65535;
    }

    public static final double eq(Point3D p1, Point3D p2, Point3D p3) {
        if (p1 == null || p2 == null || p3 == null) {
            return -1.0;
        }
        double diff12X = p1.getX() - p2.getX();
        double diff21Z = p2.getZ() - p1.getZ();
        double diff12Y = p1.getY() - p2.getY();
        double a = 1.0;
        double b = -a * ((double)p3.getX() * diff21Z + (double)p3.getZ() * diff12X - (double)p1.getX() - (double)p1.getZ() * diff12X) / ((double)p3.getY() * diff21Z + 9.0 * diff12Y - (double)p1.getY() - (double)p1.getZ() * diff12Y);
        double c = (a * diff12X + b * diff12Y) / diff21Z;
        double d = -a * (double)p1.getX() - b * (double)p1.getY() - c * (double)p1.getZ();
        System.out.println("a=" + a);
        System.out.println("b=" + b);
        System.out.println("c=" + c);
        System.out.println("d=" + d);
        System.out.println("eq test p1 =" + Util.eqTest(a, b, c, d, p1));
        System.out.println("eq test p2 =" + Util.eqTest(a, b, c, d, p2));
        System.out.println("eq test p3 =" + Util.eqTest(a, b, c, d, p3));
        return -1.0;
    }

    public static final double eqTest(double a, double b, double c, double d, Point3D p) {
        if (p == null) {
            return -1.0;
        }
        return a * (double)p.getX() + b * (double)p.getY() + c * (double)p.getZ() + d;
    }

    public static final int charCount(String s, char c) {
        if (s == null) {
            return 0;
        }
        int len = s.length();
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static final String toTimeHumanReadable(long time) {
        long min = time / 60000L;
        long minRest = time % 60000L;
        long sec = minRest / 1000L;
        long mili = minRest % 1000L;
        return String.format("%02d:%02d.%03d", min, sec, mili);
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static final String shortPath(File file, int maxLen) {
        if (file == null) {
            return "";
        }
        String path = file.getAbsolutePath();
        int len = path.length();
        if (len > maxLen) {
            String filename = file.getName();
            int filenameLen = filename.length();
            if (filenameLen > maxLen - 4) {
                int startLen = maxLen / 3;
                return "..." + File.separator + filename.substring(0, startLen) + "..." + filename.substring(filenameLen - maxLen + 7 + startLen, filenameLen);
            }
            return path.substring(0, maxLen - 4 - filenameLen) + "..." + File.separator + filename;
        }
        return path;
    }

    public static final String shortPath(String filename, int maxLen) {
        if (filename == null || "".equals(filename)) {
            return "";
        }
        return Util.shortPath(new File(filename), maxLen);
    }

    public static final double[] removeNaN(double[] array) {
        if (array == null) {
            return null;
        }
        double[] tmp = new double[array.length];
        int c = 0;
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            tmp[c++] = array[i];
        }
        double[] result = new double[c];
        System.arraycopy(tmp, 0, result, 0, c);
        return result;
    }

    public static double[] toArray(Collection<Double> col) {
        if (col == null) {
            return null;
        }
        double[] result = new double[col.size()];
        int i = 0;
        for (Double val : col) {
            result[i++] = val;
        }
        return result;
    }
}

