/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableNamedExpressionsElement;
import org.odftoolkit.odfdom.dom.element.table.TableNamedRangeElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.CellCoverInfo;
import org.odftoolkit.simple.table.Column;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellRange {
    private int mnStartRow;
    private int mnStartColumn;
    private int mnEndRow;
    private int mnEndColumn;
    private String msCellRangeName;
    private Table maOwnerTable;
    private boolean mbSpreadsheet;

    CellRange(Table table, int startColumn, int startRow, int endColumn, int endRow) {
        int colIndex;
        int rowIndex;
        Cell cell;
        int i;
        this.maOwnerTable = table;
        Document doc = (Document)((OdfFileDom)this.maOwnerTable.getOdfElement().getOwnerDocument()).getDocument();
        if (doc instanceof SpreadsheetDocument) {
            this.mbSpreadsheet = true;
        }
        this.mnStartColumn = startColumn;
        this.mnStartRow = startRow;
        this.mnEndColumn = endColumn;
        this.mnEndRow = endRow;
        List<CellCoverInfo> coverList = this.maOwnerTable.getCellCoverInfos(0, 0, endColumn, endRow);
        for (i = startColumn; i <= endColumn; ++i) {
            cell = this.maOwnerTable.getOwnerCellByPosition(coverList, i, startRow);
            rowIndex = cell.getRowIndex();
            colIndex = cell.getColumnIndex();
            this.mnStartColumn = Math.min(this.mnStartColumn, colIndex);
            this.mnStartRow = Math.min(this.mnStartRow, rowIndex);
            this.mnEndColumn = Math.max(this.mnEndColumn, colIndex + cell.getColumnSpannedNumber() - 1);
            this.mnEndRow = Math.max(this.mnEndRow, rowIndex + cell.getRowSpannedNumber() - 1);
        }
        for (i = startColumn; i <= endColumn; ++i) {
            cell = this.maOwnerTable.getOwnerCellByPosition(coverList, i, endRow);
            rowIndex = cell.getRowIndex();
            colIndex = cell.getColumnIndex();
            this.mnStartColumn = Math.min(this.mnStartColumn, colIndex);
            this.mnStartRow = Math.min(this.mnStartRow, rowIndex);
            this.mnEndColumn = Math.max(this.mnEndColumn, colIndex + cell.getColumnSpannedNumber() - 1);
            this.mnEndRow = Math.max(this.mnEndRow, rowIndex + cell.getRowSpannedNumber() - 1);
        }
        for (i = startRow + 1; i < endRow; ++i) {
            cell = this.maOwnerTable.getOwnerCellByPosition(coverList, startColumn, i);
            rowIndex = cell.getRowIndex();
            colIndex = cell.getColumnIndex();
            this.mnStartColumn = Math.min(this.mnStartColumn, colIndex);
            this.mnStartRow = Math.min(this.mnStartRow, rowIndex);
            this.mnEndColumn = Math.max(this.mnEndColumn, colIndex + cell.getColumnSpannedNumber() - 1);
            this.mnEndRow = Math.max(this.mnEndRow, rowIndex + cell.getRowSpannedNumber() - 1);
        }
        for (i = startRow + 1; i < endRow; ++i) {
            cell = this.maOwnerTable.getOwnerCellByPosition(coverList, endColumn, i);
            rowIndex = cell.getRowIndex();
            colIndex = cell.getColumnIndex();
            this.mnStartColumn = Math.min(this.mnStartColumn, colIndex);
            this.mnStartRow = Math.min(this.mnStartRow, rowIndex);
            this.mnEndColumn = Math.max(this.mnEndColumn, colIndex + cell.getColumnSpannedNumber() - 1);
            this.mnEndRow = Math.max(this.mnEndRow, rowIndex + cell.getRowSpannedNumber() - 1);
        }
    }

    CellRange() {
    }

    public void merge() {
        Cell firstCell = this.maOwnerTable.getCellByPosition(this.mnStartColumn, this.mnStartRow);
        int rowCount = this.maOwnerTable.getRowCount();
        int colCount = this.maOwnerTable.getColumnCount();
        if (rowCount == this.mnEndRow - this.mnStartRow + 1 && colCount == this.mnEndColumn - this.mnStartColumn + 1 && !this.mbSpreadsheet) {
            if (firstCell.getOdfElement() instanceof TableTableCellElement) {
                TableTableCellElement firstCellElement = (TableTableCellElement)firstCell.getOdfElement();
                firstCellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-spanned");
                firstCellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-spanned");
                firstCellElement.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
            }
            for (int i = this.mnStartRow; i < this.mnEndRow + 1; ++i) {
                for (int j = this.mnStartColumn; j < this.mnEndColumn + 1; ++j) {
                    Cell cellBase = this.maOwnerTable.getCellByPosition(j, i);
                    if (j == this.mnStartColumn && i == this.mnStartRow) continue;
                    firstCell.appendContentFrom(cellBase);
                }
            }
            this.maOwnerTable.removeRowsByIndex(1, this.maOwnerTable.getRowCount() - 1);
            this.maOwnerTable.removeColumnsByIndex(1, this.maOwnerTable.getColumnCount() - 1);
            Column firstColumn = this.maOwnerTable.getColumnByIndex(0);
            firstColumn.setWidth(this.maOwnerTable.getWidth());
            this.mnEndRow = this.mnStartRow;
            this.mnEndColumn = this.mnStartColumn;
            return;
        }
        if (rowCount == this.mnEndRow - this.mnStartRow + 1 && colCount > this.mnEndColumn - this.mnStartColumn + 1 && this.mnEndColumn - this.mnStartColumn > 0) {
            if (firstCell.getOdfElement() instanceof TableTableCellElement) {
                TableTableCellElement firstCellElement = (TableTableCellElement)firstCell.getOdfElement();
                firstCellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-spanned");
                firstCellElement.setTableNumberRowsSpannedAttribute(Integer.valueOf(this.mnEndRow - this.mnStartRow + 1));
                firstCellElement.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
            }
            for (int i = this.mnStartRow; i < this.mnEndRow + 1; ++i) {
                for (int j = this.mnStartColumn; j < this.mnEndColumn + 1; ++j) {
                    Cell cellBase = this.maOwnerTable.getCellByPosition(j, i);
                    if (j == this.mnStartColumn && i == this.mnStartRow) continue;
                    firstCell.appendContentFrom(cellBase);
                    if (j != this.mnStartColumn || !(cellBase.getOdfElement() instanceof TableTableCellElement)) continue;
                    TableTableCellElement firstColumnCell = (TableTableCellElement)cellBase.getOdfElement();
                    TableCoveredTableCellElement coveredCell = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)((OdfFileDom)firstColumnCell.getOwnerDocument()), (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.TABLE, (String)"covered-table-cell"));
                    Row parentRow = cellBase.getTableRow();
                    parentRow.getOdfElement().insertBefore((Node)coveredCell, (Node)firstColumnCell);
                    parentRow.getOdfElement().removeChild((Node)firstColumnCell);
                }
            }
            List<Double> widthList = this.getCellRangeWidthList();
            double nCellRangeWidth = widthList.get(widthList.size() - 1) - widthList.get(0);
            this.maOwnerTable.removeColumnsByIndex(this.mnStartColumn + 1, this.mnEndColumn - this.mnStartColumn);
            Column firstColumn = this.maOwnerTable.getColumnByIndex(this.mnStartColumn);
            firstColumn.setWidth(nCellRangeWidth);
            this.mnEndColumn = this.mnStartColumn;
            return;
        }
        if (rowCount > this.mnEndRow - this.mnStartRow + 1 && colCount == this.mnEndColumn - this.mnStartColumn + 1 && this.mnEndRow - this.mnStartRow > 0) {
            if (firstCell.getOdfElement() instanceof TableTableCellElement) {
                TableTableCellElement firstCellElement = (TableTableCellElement)firstCell.getOdfElement();
                firstCellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-spanned");
                firstCellElement.setTableNumberColumnsSpannedAttribute(Integer.valueOf(this.mnEndColumn - this.mnStartColumn + 1));
                firstCellElement.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
            }
            for (int i = this.mnStartRow; i < this.mnEndRow + 1; ++i) {
                for (int j = this.mnStartColumn; j < this.mnEndColumn + 1; ++j) {
                    Cell cellBase = this.maOwnerTable.getCellByPosition(j, i);
                    if (j == this.mnStartColumn && i == this.mnStartRow) continue;
                    firstCell.appendContentFrom(cellBase);
                    if (i != this.mnStartRow || !(cellBase.getOdfElement() instanceof TableTableCellElement)) continue;
                    TableTableCellElement firstRowCell = (TableTableCellElement)cellBase.getOdfElement();
                    TableCoveredTableCellElement coveredCell = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)((OdfFileDom)firstRowCell.getOwnerDocument()), (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.TABLE, (String)"covered-table-cell"));
                    Row parentRow = cellBase.getTableRow();
                    parentRow.getOdfElement().insertBefore((Node)coveredCell, (Node)firstRowCell);
                    parentRow.getOdfElement().removeChild((Node)firstRowCell);
                }
            }
            this.maOwnerTable.removeRowsByIndex(this.mnStartRow + 1, this.mnEndRow - this.mnStartRow);
            this.mnEndRow = this.mnStartRow;
            return;
        }
        if (firstCell.getOdfElement() instanceof TableTableCellElement) {
            firstCell.splitRepeatedCells();
            TableTableCellElement firstCellElement = (TableTableCellElement)firstCell.getOdfElement();
            firstCellElement.setTableNumberColumnsSpannedAttribute(Integer.valueOf(this.mnEndColumn - this.mnStartColumn + 1));
            firstCellElement.setTableNumberRowsSpannedAttribute(Integer.valueOf(this.mnEndRow - this.mnStartRow + 1));
        }
        for (int i = this.mnStartRow; i < this.mnEndRow + 1; ++i) {
            for (int j = this.mnStartColumn; j < this.mnEndColumn + 1; ++j) {
                Cell cellBase = this.maOwnerTable.getCellByPosition(j, i);
                if (j == this.mnStartColumn && i == this.mnStartRow) continue;
                if (cellBase.getOdfElement() instanceof TableTableCellElement) {
                    TableTableCellElement cell = (TableTableCellElement)cellBase.getOdfElement();
                    TableCoveredTableCellElement coveredCell = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)((OdfFileDom)cell.getOwnerDocument()), (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.TABLE, (String)"covered-table-cell"));
                    TableTableRowElement parentRowEle = cellBase.getTableRow().getOdfElement();
                    parentRowEle.insertBefore((Node)coveredCell, (Node)cell);
                    firstCell.appendContentFrom(cellBase);
                    cellBase.removeContent();
                    int repeatedNum = cell.getTableNumberColumnsRepeatedAttribute();
                    int num = this.mnEndColumn - j + 1 - repeatedNum;
                    if (num >= 0) {
                        if (repeatedNum > 1) {
                            coveredCell.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(repeatedNum));
                        }
                        parentRowEle.removeChild((Node)cell);
                        continue;
                    }
                    int tableNumberColumnsRepeatedValue = this.mnEndColumn - j + 1;
                    if (tableNumberColumnsRepeatedValue > 1) {
                        coveredCell.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(tableNumberColumnsRepeatedValue));
                    }
                    cell.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(-num));
                    continue;
                }
                if (!(cellBase.getOdfElement() instanceof TableCoveredTableCellElement)) continue;
                try {
                    firstCell.appendContentFrom(cellBase);
                    cellBase.removeContent();
                    continue;
                }
                catch (Exception e) {
                    Logger.getLogger(CellRange.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    private List<Double> getCellRangeWidthList() {
        ArrayList<Double> list = new ArrayList<Double>();
        Double length = 0.0;
        for (int i = 0; i < this.maOwnerTable.getColumnCount() - 1; ++i) {
            Column col = this.maOwnerTable.getColumnByIndex(i);
            int repeateNum = col.getColumnsRepeatedNumber();
            if (repeateNum == 1) {
                if (this.isColumnInCellRange(i)) {
                    list.add(length);
                }
                length = length + col.getWidth();
                continue;
            }
            for (int j = 0; j < repeateNum; ++j) {
                if (!this.isColumnInCellRange(i + j)) continue;
                list.add(length);
                length = length + col.getWidth();
            }
            i += repeateNum - 1;
        }
        list.add(length);
        return list;
    }

    List<Double> getVeticalSplitCellRangeWidthList(int splitNum) {
        List<CellCoverInfo> coverList = this.maOwnerTable.getCellCoverInfos(this.mnStartColumn, this.mnStartRow, this.mnEndColumn, this.mnEndRow);
        ArrayList<Double> tmpList = new ArrayList<Double>();
        List<Double> widthList = this.getCellRangeWidthList();
        for (int i = this.mnStartColumn; i < this.mnEndColumn + 1; ++i) {
            for (int j = this.mnStartRow; j < this.mnEndRow + 1; ++j) {
                Double width;
                if (this.maOwnerTable.isCoveredCellInOwnerTable(coverList, i, j) || tmpList.contains(width = widthList.get(i - this.mnStartColumn))) continue;
                tmpList.add(width);
            }
        }
        Object[] widthArray = (Double[])tmpList.toArray();
        Arrays.sort(widthArray);
        ArrayList<Double> rtnValues = new ArrayList<Double>();
        rtnValues.add((Double)widthArray[0]);
        for (int i = 1; i < widthArray.length; ++i) {
            double colWidth = (Double)widthArray[i] - (Double)widthArray[i - 1];
            double unitWidth = colWidth / (double)splitNum;
            for (int j = 1; j < splitNum; ++j) {
                double eachWidth = unitWidth * (double)j + (Double)widthArray[i - 1];
                rtnValues.add(eachWidth);
            }
            rtnValues.add((Double)widthArray[i]);
        }
        return rtnValues;
    }

    public String getCellRangeName() {
        return this.msCellRangeName;
    }

    public void setCellRangeName(String cellRangeName) {
        try {
            OdfElement contentRoot = this.maOwnerTable.mDocument.getContentRoot();
            OdfFileDom contentDom = (OdfFileDom)this.maOwnerTable.getOdfElement().getOwnerDocument();
            TableNamedExpressionsElement nameExpress = (TableNamedExpressionsElement)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.TABLE, (String)"named-expressions"));
            String startCellRange = "$" + this.maOwnerTable.getTableName() + "." + this.maOwnerTable.getAbsoluteCellAddress(this.mnStartColumn, this.mnStartRow);
            String endCellRange = "$" + this.maOwnerTable.getTableName() + "." + this.maOwnerTable.getAbsoluteCellAddress(this.mnEndColumn, this.mnEndRow);
            TableNamedRangeElement nameRange = nameExpress.newTableNamedRangeElement(startCellRange + ":" + endCellRange, cellRangeName);
            nameRange.setTableBaseCellAddressAttribute(endCellRange);
            contentRoot.appendChild((Node)nameExpress);
            this.msCellRangeName = cellRangeName;
        }
        catch (Exception ex) {
            Logger.getLogger(CellRange.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Table getTable() {
        return this.maOwnerTable;
    }

    public int getRowNumber() {
        return this.mnEndRow - this.mnStartRow + 1;
    }

    public int getColumnNumber() {
        return this.mnEndColumn - this.mnStartColumn + 1;
    }

    public Cell getCellByPosition(int clmIndex, int rowIndex) throws IndexOutOfBoundsException {
        return this.maOwnerTable.getCellByPosition(this.mnStartColumn + clmIndex, this.mnStartRow + rowIndex);
    }

    private boolean isColumnInCellRange(int colIndex) {
        return colIndex >= this.mnStartColumn && colIndex <= this.mnEndColumn;
    }

    public Cell getCellByPosition(String address) {
        return this.getCellByPosition(this.maOwnerTable.getColIndexFromCellAddress(address), this.maOwnerTable.getRowIndexFromCellAddress(address));
    }
}

