/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepObserverRegistry;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public final class Common {
    public static void writeLog(OutputStream os, long startTime, String data) throws IOException {
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        OutputStreamWriter writer = new OutputStreamWriter(os, Globals.DEFAULT_CHARSET);
        writer.write("Start time: " + new Date(startTime) + "\nEnd time: " + new Date(endTime) + "\nDuration: " + StringUtils.toTimeHumanReadable((long)duration) + "\n");
        writer.write(data);
        ((Writer)writer).close();
    }

    public static void writeLog(File file, long startTime, String data) throws IOException {
        if (file == null) {
            throw new NullPointerException("File for log file is null.");
        }
        Common.writeLog(FileUtils.createOutputStream((File)file), startTime, data);
    }

    public static void showMessageAndExit(String message) {
        System.out.println(message);
        Common.exit(0);
    }

    public static void showAndLogErrorMessage(String message) {
        EoulsanLogger.getLogger().severe(message);
        System.err.println(message);
    }

    public static void showErrorMessageAndExit(String message) {
        System.err.println(message);
        Common.exit(1);
    }

    public static void errorExit(Throwable e, String message) {
        Common.errorExit(e, message, true);
    }

    public static void errorExit(Throwable e, String message, boolean logMessage) {
        if (logMessage) {
            EoulsanLogger.getLogger().severe(message);
        }
        System.err.println("\n=== Eoulsan Error ===");
        System.err.println(message);
        if (!EoulsanRuntime.isRuntime() || EoulsanRuntime.getSettings().isPrintStackTrace()) {
            Common.printStackTrace(e);
        }
        Common.exit(1);
    }

    public static void errorHalt(Throwable e, String message) {
        Common.errorHalt(e, message, true);
    }

    public static void errorHalt(Throwable e, String message, boolean logMessage) {
        if (logMessage) {
            EoulsanLogger.getLogger().severe(message);
        }
        System.err.println("\n=== Eoulsan Error ===");
        System.err.println(message);
        if (!EoulsanRuntime.isRuntime() || EoulsanRuntime.getSettings().isPrintStackTrace()) {
            Common.printStackTrace(e);
        }
        Common.halt(1);
    }

    private static void printStackTrace(Throwable e) {
        System.err.println("\n=== Eoulsan Debug Stack Trace ===");
        e.printStackTrace();
        System.err.println();
    }

    public static void exit(int exitCode) {
        System.exit(exitCode);
    }

    public static void halt(int exitCode) {
        Runtime.getRuntime().halt(exitCode);
    }

    public static void sendMail(String subject, String message) {
        block6: {
            if (!EoulsanRuntime.isRuntime()) {
                return;
            }
            Settings settings = EoulsanRuntime.getSettings();
            boolean sendMail = settings.isSendResultMail();
            Properties properties = settings.getJavaMailSMTPProperties();
            String userMail = settings.getResultMail();
            if (!sendMail) {
                return;
            }
            if (!properties.containsKey("mail.smtp.host")) {
                EoulsanLogger.getLogger().warning("No SMTP server set");
                return;
            }
            if (userMail == null) {
                EoulsanLogger.getLogger().warning("No user mail set");
                return;
            }
            Session session = Session.getInstance((Properties)properties);
            try {
                MimeMessage msg = new MimeMessage(session);
                msg.setFrom((Address)new InternetAddress(userMail));
                InternetAddress[] address = new InternetAddress[]{new InternetAddress(userMail)};
                msg.setRecipients(Message.RecipientType.TO, (Address[])address);
                msg.setSubject(subject);
                msg.setSentDate(new Date());
                msg.setText(message);
                Transport.send((Message)msg);
            }
            catch (MessagingException mex) {
                EoulsanLogger.getLogger().warning("Error while sending mail: " + mex.getMessage());
                if (EoulsanRuntime.isRuntime() && !EoulsanRuntime.getSettings().isPrintStackTrace()) break block6;
                mex.printStackTrace();
            }
        }
    }

    public static int getThreadsNumber(int localThreads, int maxLocalThreads) {
        int threads = EoulsanRuntime.getSettings().getLocalThreadsNumber();
        if (localThreads > 0) {
            threads = localThreads;
        }
        if (maxLocalThreads > 0) {
            threads = Math.min(threads, maxLocalThreads);
        }
        return threads;
    }

    public static void printWarning(String message) {
        if (message == null) {
            return;
        }
        if (StepObserverRegistry.getInstance().isNoObserverRegistered()) {
            System.err.println(message);
        }
    }

    private Common() {
        throw new IllegalStateException();
    }
}

