/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import fr.ens.biologie.genomique.eoulsan.AbstractEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Handler;
import java.util.logging.Level;

public final class LocalEoulsanRuntime
extends AbstractEoulsanRuntime {
    private AbstractEoulsanRuntime.EoulsanExecMode mode;

    @Override
    public AbstractEoulsanRuntime.EoulsanExecMode getMode() {
        return this.mode != null ? this.mode : AbstractEoulsanRuntime.EoulsanExecMode.LOCAL;
    }

    @Override
    public File getTempDirectory() {
        return this.getSettings().getTempDirectoryFile();
    }

    @Override
    public InputStream getInputStream(String dataSource) throws IOException {
        if (dataSource == null) {
            throw new IllegalArgumentException("The datasource is null.");
        }
        File file = new File(dataSource);
        return this.decompressInputStreamIsNeeded(FileUtils.createInputStream((File)file), dataSource);
    }

    @Override
    public InputStream getRawInputStream(String dataSource) throws IOException {
        if (dataSource == null) {
            throw new IllegalArgumentException("The datasource is null.");
        }
        File file = new File(dataSource);
        return FileUtils.createInputStream((File)file);
    }

    @Override
    public OutputStream getOutputStream(String dataSource) throws IOException {
        if (dataSource == null) {
            throw new IllegalArgumentException("The datasource is null.");
        }
        File file = new File(dataSource);
        return FileUtils.createOutputStream((File)file);
    }

    public void setMode(AbstractEoulsanRuntime.EoulsanExecMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode argument cannot be null");
        }
        if (this.mode != null) {
            throw new IllegalStateException("Eoulsan mode has been already set");
        }
        this.mode = mode;
    }

    public static LocalEoulsanRuntime newEoulsanRuntime(Settings settings) {
        LocalEoulsanRuntime instance = new LocalEoulsanRuntime(settings);
        EoulsanRuntime.setInstance(instance);
        return instance;
    }

    private LocalEoulsanRuntime(Settings settings) {
        super(settings);
    }

    public static void initEoulsanRuntimeForExternalApp() throws IOException, EoulsanException {
        Handler[] handlers;
        if (!EoulsanRuntime.isRuntime()) {
            LocalEoulsanRuntime.newEoulsanRuntime(new Settings(true));
            ((LocalEoulsanRuntime)EoulsanRuntime.getRuntime()).setMode(AbstractEoulsanRuntime.EoulsanExecMode.EXTERNAL_APP);
        }
        if ((handlers = EoulsanLogger.getLogger().getHandlers()) != null) {
            for (Handler handler : handlers) {
                handler.setLevel(Level.OFF);
            }
        }
    }
}

