/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import fr.ens.biologie.genomique.eoulsan.BufferedHandler;
import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Infos;
import fr.ens.biologie.genomique.eoulsan.MainCLI;
import fr.ens.biologie.genomique.eoulsan.MainHadoop;
import fr.ens.biologie.genomique.eoulsan.OtherLogConfigurator;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.actions.Action;
import fr.ens.biologie.genomique.eoulsan.actions.ActionService;
import fr.ens.biologie.genomique.kenetre.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.python.google.common.base.Strings;

public abstract class Main {
    public static final String EOULSAN_CLASSPATH_JVM_ARG = "eoulsan.classpath";
    public static final String EOULSAN_SCRIPT = "eoulsan.launch.script.path";
    public static final String EOULSAN_PATH = "eoulsan.path";
    public static final String EOULSAN_MEMORY = "eoulsan.memory";
    private static Main main;
    private final String launchModeName;
    private final List<String> args;
    private Action action;
    private List<String> actionArgs;
    private String logLevel;
    private String logFile;
    private String conf;
    private List<String> commandLineSettings;
    private final BufferedHandler handler = new BufferedHandler();

    public static Main getInstance() {
        return main;
    }

    public String getJavaExecutablePath() {
        return System.getProperty("java.home") + "/bin/java";
    }

    public List<String> getJVMArgs() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }

    public String getClassPath() {
        return System.getProperty(EOULSAN_CLASSPATH_JVM_ARG);
    }

    public String getEoulsanScriptPath() {
        return System.getProperty(EOULSAN_SCRIPT);
    }

    public int getEoulsanMemory() {
        String value = System.getProperty(EOULSAN_MEMORY);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public File getEoulsanDirectory() {
        String eoulsanPath = System.getProperty(EOULSAN_PATH);
        if (eoulsanPath == null) {
            throw new NullPointerException("Unknown install path of Eoulsan");
        }
        return new File(eoulsanPath);
    }

    public List<String> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public Action getAction() {
        return this.action;
    }

    public List<String> getActionArgs() {
        return Collections.unmodifiableList(this.actionArgs);
    }

    public String getLogLevelArgument() {
        return this.logLevel;
    }

    public String getLogFileArgument() {
        return this.logFile;
    }

    public String getConfigurationFileArgument() {
        return this.conf;
    }

    public List<String> getCommandLineSettings() {
        if (this.commandLineSettings == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.commandLineSettings);
    }

    public String getLaunchScriptPath() {
        return System.getProperty(Globals.LAUNCH_SCRIPT_PATH);
    }

    public String getLaunchMode() {
        return this.launchModeName;
    }

    protected void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getHelpEoulsanCommand() + " [options] action arguments", options);
        System.out.println("Available actions:");
        for (Action action : ActionService.getInstance().getActions()) {
            if (action.isHadoopJarMode() || action.isHidden()) continue;
            System.out.println(Strings.padEnd((String)(" - " + action.getName()), (int)23, (char)' ') + action.getDescription() + (!action.isCurrentArchCompatible() ? " (not available for your platform)." : ""));
        }
        Common.exit(0);
    }

    protected Options makeOptions() {
        Options options = new Options();
        options.addOption("version", false, "show version of the software");
        options.addOption("about", false, "display information about this software");
        options.addOption("h", "help", false, "display this help");
        options.addOption("license", false, "display information about the license of this software");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"configuration file to use");
        options.addOption(OptionBuilder.create((String)"conf"));
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set a configuration setting. This option can be used several times");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"external log file");
        options.addOption(OptionBuilder.create((String)"log"));
        OptionBuilder.withArgName((String)"level");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"log level");
        options.addOption(OptionBuilder.create((String)"loglevel"));
        return options;
    }

    private int parseCommandLine() {
        Options options = this.makeOptions();
        GnuParser parser = new GnuParser();
        String[] argsArray = this.args.toArray(new String[0]);
        int argsOptions = 0;
        try {
            CommandLine line = parser.parse(options, argsArray, true);
            if (line.hasOption("help")) {
                this.help(options);
            }
            if (line.hasOption("about")) {
                Common.showMessageAndExit(Globals.ABOUT_TXT);
            }
            if (line.hasOption("version")) {
                Common.showMessageAndExit(Globals.WELCOME_MSG);
            }
            if (line.hasOption("license")) {
                Common.showMessageAndExit("This program is developed under the GNU Lesser General Public License version 2.1 or later and CeCILL-C.");
            }
            if (line.hasOption("log")) {
                argsOptions += 2;
                this.logFile = line.getOptionValue("log");
            }
            if (line.hasOption("loglevel")) {
                argsOptions += 2;
                this.logLevel = line.getOptionValue("loglevel");
            }
            if (line.hasOption("conf")) {
                argsOptions += 2;
                this.conf = line.getOptionValue("conf");
            }
            if (line.hasOption('s')) {
                this.commandLineSettings = Arrays.asList(line.getOptionValues('s'));
                argsOptions += 2 * this.commandLineSettings.size();
            }
            if (line.hasOption('j')) {
                argsOptions += 2;
            }
            if (line.hasOption('m')) {
                argsOptions += 2;
            }
            if (line.hasOption('J')) {
                argsOptions += 2;
            }
            if (line.hasOption('p')) {
                argsOptions += 2;
            }
            if (line.hasOption('w')) {
                argsOptions += 2;
            }
        }
        catch (ParseException e) {
            Common.errorExit(e, "Error while parsing command line arguments: " + e.getMessage());
        }
        if (this.args == null || this.args.size() == argsOptions) {
            Common.showErrorMessageAndExit("This program needs one argument. Use the -h option to get more information.\n");
        }
        return argsOptions;
    }

    private static String availableArchsToString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String osArch : Globals.AVAILABLE_BINARY_ARCH) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(osArch.replace('\t', '/'));
        }
        return sb.toString();
    }

    private void startupLog() {
        EoulsanLogger.getLogger().info("Welcome to " + Globals.WELCOME_MSG);
        EoulsanLogger.getLogger().info("Start in " + this.launchModeName + " mode");
        Infos.log(Level.INFO, Infos.softwareInfos(this));
        Infos.log(Level.INFO, Infos.commandLineInfo(this));
    }

    protected void sysInfoLog() {
        Infos.log(Level.INFO, Infos.systemInfos());
    }

    private Settings loadConfigurationFile() throws IOException, EoulsanException {
        if (this.conf != null) {
            return new Settings(new File(this.conf));
        }
        File defaultConfFile = new File(Settings.getConfigurationFilePath());
        if (defaultConfFile.exists()) {
            this.conf = defaultConfFile.getAbsolutePath();
            return new Settings(defaultConfFile);
        }
        EoulsanLogger.getLogger().config("No configuration file found.");
        return new Settings(false);
    }

    private void setManualSettings(Settings settings) {
        for (String s : this.getCommandLineSettings()) {
            int index = s.indexOf(61);
            if (index == -1) {
                settings.setSetting(s, "");
                continue;
            }
            settings.setSetting(s.substring(0, index), s.substring(index + 1));
        }
    }

    private void initApplicationLogger() {
        EoulsanLogger.getLogger().setUseParentHandlers(false);
        EoulsanLogger.getLogger().setLevel(Level.ALL);
        EoulsanLogger.getLogger().addHandler(this.handler);
        this.handler.setFormatter(Globals.LOG_FORMATTER);
        if (this.logLevel != null) {
            try {
                this.handler.setLevel(Level.parse(this.logLevel.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                Common.showErrorMessageAndExit("Unknown log level (" + this.logLevel + "). Accepted values are [SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST].");
            }
        } else {
            this.handler.setLevel(Globals.LOG_LEVEL);
        }
        if (this.logFile != null) {
            try {
                this.handler.addHandler(this.getLogHandler(new File(this.logFile).getAbsoluteFile().toURI()));
            }
            catch (IOException e) {
                Common.errorExit(e, "Error while creating log file: " + e.getMessage());
            }
        }
    }

    public void createLogFileAndFlushLog(URI logFilename) throws EoulsanException {
        try {
            Handler h = this.getLogHandler(logFilename);
            this.handler.addHandler(h);
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
        this.flushLog();
    }

    public void createOtherLog(URI logFilename) {
        OtherLogConfigurator.configureLog4J(null, new File(logFilename).getAbsolutePath());
    }

    public void createLogFiles(URI EoulsanlogFilename, URI otherlogFilename) throws EoulsanException {
        this.createLogFileAndFlushLog(EoulsanlogFilename);
        this.createOtherLog(otherlogFilename);
    }

    public void flushLog() {
        this.handler.flush();
    }

    private void parseAction(int optionsCount) {
        String actionName = this.args.get(optionsCount).trim().toLowerCase();
        this.actionArgs = this.args.subList(optionsCount + 1, this.args.size());
        boolean hadoopMode = EoulsanRuntime.getRuntime().getMode().isHadoopMode();
        this.action = (Action)ActionService.getInstance().newService(actionName);
        if (this.action == null || hadoopMode != this.action.isHadoopJarMode()) {
            Common.showErrorMessageAndExit("Unknown action: " + actionName + ".\ntype: " + Globals.APP_NAME_LOWER_CASE + " -help for more help.\n");
        }
    }

    protected abstract void initializeRuntime(Settings var1) throws EoulsanException;

    protected abstract String getHelpEoulsanCommand();

    protected abstract Handler getLogHandler(URI var1) throws IOException;

    Main(String modeName, String[] args) {
        this.launchModeName = modeName;
        this.args = Arrays.asList(args);
        int optionsCount = this.parseCommandLine();
        this.initApplicationLogger();
        this.startupLog();
        try {
            Settings settings = this.loadConfigurationFile();
            this.setManualSettings(settings);
            settings.logSettings();
            this.initializeRuntime(settings);
            this.sysInfoLog();
        }
        catch (IOException e) {
            Common.errorExit(e, "Error while reading configuration file.");
        }
        catch (EoulsanException e) {
            Common.errorExit(e, e.getMessage());
        }
        this.parseAction(optionsCount);
    }

    public static void main(String[] args) {
        String eoulsanMode;
        if (main != null) {
            throw new IllegalAccessError("Main method cannot be run twice.");
        }
        Globals.setDefaultLocale();
        if (SystemUtils.getJavaVersion() < 8) {
            Common.showErrorMessageAndExit(Globals.WELCOME_MSG + "\nError: Eoulsan requires Java 8 (found Java " + SystemUtils.getJavaVersion() + ").");
        }
        main = (eoulsanMode = System.getProperty(Globals.LAUNCH_MODE_PROPERTY)) != null && eoulsanMode.equals("local") ? new MainCLI(args) : new MainHadoop(args);
        Action action = main.getAction();
        Settings settings = EoulsanRuntime.getSettings();
        if (!settings.isBypassPlatformChecking() && !action.isCurrentArchCompatible()) {
            Common.showErrorMessageAndExit(Globals.WELCOME_MSG + "\nError: The " + action.getName() + " of Eoulsan is not available for your platform. Required platforms: " + Main.availableArchsToString() + ".");
        }
        try {
            EoulsanLogger.getLogger().info("Start " + action.getName() + " action");
            action.action(main.getActionArgs());
            EoulsanLogger.getLogger().info("End of " + action.getName() + " action");
        }
        catch (Throwable e) {
            Common.errorExit(e, e.getMessage());
        }
        main.flushLog();
    }
}

