/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.HadoopEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Infos;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.Settings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.StreamHandler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.VersionInfo;

public final class MainHadoop
extends Main {
    private static final String LAUNCH_MODE_NAME = "hadoop";
    private Configuration conf;

    @Override
    protected void initializeRuntime(Settings settings) {
        this.conf = HadoopEoulsanRuntime.newEoulsanRuntime(settings).getConfiguration();
    }

    @Override
    protected String getHelpEoulsanCommand() {
        return "hadoop jar " + Globals.APP_NAME_LOWER_CASE + ".jar";
    }

    @Override
    protected Handler getLogHandler(URI logFile) throws IOException {
        if (logFile == null) {
            throw new NullPointerException("The log file is null");
        }
        Path loggerPath = new Path(logFile);
        FileSystem loggerFs = loggerPath.getFileSystem(this.conf);
        Path parentPath = loggerPath.getParent();
        if (!loggerFs.exists(loggerPath.getParent()) && !loggerFs.mkdirs(loggerPath.getParent())) {
            throw new IOException("Unable to create directory " + parentPath + " for log file:" + logFile);
        }
        return new StreamHandler((OutputStream)loggerFs.create(loggerPath), Globals.LOG_FORMATTER);
    }

    @Override
    protected void sysInfoLog() {
        super.sysInfoLog();
        try {
            File tmpDir;
            Infos.log(Level.INFO, Infos.cpuInfo());
            Infos.log(Level.INFO, Infos.memInfo());
            Infos.log(Level.INFO, Infos.partitionInfo(EoulsanRuntime.getSettings()));
            String hadoopTmp = this.conf.get("hadoop.tmp.dir");
            if (hadoopTmp != null) {
                Infos.log(Level.INFO, Collections.singletonList(Infos.diskFreeInfo(new File(hadoopTmp))));
            }
            if ((tmpDir = new File(System.getProperty("java.io.tmpdir"))) != null && tmpDir.exists() && tmpDir.isDirectory()) {
                Infos.log(Level.INFO, Infos.diskFreeInfo(new File(hadoopTmp)));
            }
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().severe("Error while getting system information: " + e.getMessage());
        }
        Infos.log(Level.INFO, new Infos.Info("Hadoop version", VersionInfo.getVersion()));
        Infos.log(Level.INFO, new Infos.Info("Hadoop revision", VersionInfo.getRevision()));
        Infos.log(Level.INFO, new Infos.Info("Hadoop date", VersionInfo.getDate()));
        Infos.log(Level.INFO, new Infos.Info("Hadoop user", VersionInfo.getUser()));
        Infos.log(Level.INFO, new Infos.Info("Hadoop url", VersionInfo.getUrl()));
    }

    protected MainHadoop(String[] args) {
        super(LAUNCH_MODE_NAME, args);
    }
}

