/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class OtherLogConfigurator {
    private static final Level DEFAULT_LOG_LEVEL = Level.INFO;

    public static void configureLog4J(String logLevel, String logFilename) {
        if (logFilename == null) {
            throw new NullPointerException("The logFilename argument cannot be null");
        }
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(Level.toLevel((String)logLevel, (Level)DEFAULT_LOG_LEVEL));
        rootLogger.removeAllAppenders();
        PatternLayout layout = new PatternLayout("%p\t%d{yyyy.MM.dd HH:mm:ss}\t%m\n");
        try {
            RollingFileAppender fileAppender = new RollingFileAppender((Layout)layout, logFilename);
            rootLogger.addAppender((Appender)fileAppender);
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().warning("Failed to add appender !!");
        }
    }
}

