/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.actions;

import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.HadoopEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.actions.AbstractAction;
import fr.ens.biologie.genomique.eoulsan.core.workflow.Executor;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ExecutorArguments;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ExecJarHadoopAction
extends AbstractAction {
    public static final String ACTION_NAME = "execjarhadoop";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getDescription() {
        return "Execute Eoulsan in Hadoop jar mode ";
    }

    @Override
    public boolean isHadoopJarMode() {
        return true;
    }

    @Override
    public void action(List<String> arguments) {
        int argsOptions;
        long millisSinceEpoch;
        String jobEnvironment;
        String jobDescription;
        Options options;
        block8: {
            options = ExecJarHadoopAction.makeOptions();
            GnuParser parser = new GnuParser();
            jobDescription = null;
            jobEnvironment = null;
            millisSinceEpoch = System.currentTimeMillis();
            argsOptions = 0;
            try {
                CommandLine line = parser.parse(options, arguments.toArray(new String[0]), true);
                if (line.hasOption("help")) {
                    ExecJarHadoopAction.help(options);
                }
                if (line.hasOption("d")) {
                    jobDescription = line.getOptionValue("d");
                    argsOptions += 2;
                }
                if (line.hasOption("e")) {
                    jobEnvironment = line.getOptionValue("e");
                    argsOptions += 2;
                }
                if (!line.hasOption("p")) break block8;
                try {
                    millisSinceEpoch = Long.parseLong(line.getOptionValue("p").trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                argsOptions += 2;
            }
            catch (ParseException e) {
                Common.errorExit(e, "Error while parsing command line arguments: " + e.getMessage());
            }
        }
        if (arguments.size() != argsOptions + 3) {
            ExecJarHadoopAction.help(options);
        }
        String paramPathname = ExecJarHadoopAction.convertS3URL(arguments.get(argsOptions));
        String designPathname = ExecJarHadoopAction.convertS3URL(arguments.get(argsOptions + 1));
        String destPathname = ExecJarHadoopAction.convertS3URL(arguments.get(argsOptions + 2));
        ExecJarHadoopAction.run(paramPathname, designPathname, destPathname, jobDescription, jobEnvironment, millisSinceEpoch);
    }

    private static String convertS3URL(String url) {
        return StringUtils.replacePrefix((String)url, (String)"s3:/", (String)"s3n:/");
    }

    private static Options makeOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "display this help");
        OptionBuilder.withArgName((String)"description");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"job description");
        OptionBuilder.withLongOpt((String)"jobdesc");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withArgName((String)"environment");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"environment description");
        OptionBuilder.withLongOpt((String)"envdesc");
        options.addOption(OptionBuilder.create((char)'e'));
        options.addOption("upload", false, "upload only");
        OptionBuilder.withArgName((String)"parent-job-time");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"parent job time");
        OptionBuilder.withLongOpt((String)"parent-job");
        options.addOption(OptionBuilder.create((char)'p'));
        return options;
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("hadoop -jar " + Globals.APP_NAME_LOWER_CASE + ".jar  [options] execjarhadoop workflow.xml design.txt hdfs://server/path", options);
        Common.exit(0);
    }

    private static void run(String workflowPathname, String designPathname, String destPathname, String jobDescription, String jobEnvironment, long millisSinceEpoch) {
        Objects.requireNonNull(workflowPathname, "workflowPathname is null");
        Objects.requireNonNull(designPathname, "designPathname is null");
        Objects.requireNonNull(destPathname, "destPathname is null");
        String desc = jobDescription == null ? "no job description" : jobDescription;
        String env = jobEnvironment == null ? "no environment description" : jobEnvironment;
        try {
            Configuration conf = ((HadoopEoulsanRuntime)EoulsanRuntime.getRuntime()).getConfiguration();
            URI workflowURI = workflowPathname.contains("://") ? new URI(workflowPathname) : new File(workflowPathname).getAbsoluteFile().toURI();
            URI designURI = designPathname.contains("://") ? new URI(designPathname) : new File(designPathname).getAbsoluteFile().toURI();
            URI destURI = new URI(destPathname);
            Path workflowPath = new Path(workflowURI.toString());
            Path designPath = new Path(designURI.toString());
            Path destPath = new Path(destURI.toString());
            FileSystem workflowFs = workflowPath.getFileSystem(conf);
            if (!workflowFs.exists(workflowPath)) {
                throw new FileNotFoundException(workflowPath.toString());
            }
            FileSystem designFs = designPath.getFileSystem(conf);
            if (!designFs.exists(designPath)) {
                throw new FileNotFoundException(designPath.toString());
            }
            HadoopExecutorArguments arguments = new HadoopExecutorArguments(millisSinceEpoch, workflowPath, designPath, destPath);
            arguments.setJobDescription(desc);
            arguments.setJobEnvironment(env);
            Main.getInstance().createLogFiles(arguments.logPath(Globals.LOG_FILENAME), arguments.logPath("additional.log"));
            Executor e = new Executor(arguments);
            e.execute();
        }
        catch (FileNotFoundException e) {
            Common.errorExit(e, "File not found: " + e.getMessage());
        }
        catch (IOException | URISyntaxException e) {
            Common.errorExit(e, "Error: " + e.getMessage());
        }
        catch (Throwable e) {
            Common.errorExit(e, "Error while executing " + Globals.APP_NAME_LOWER_CASE + ": " + e.getMessage());
        }
    }

    private static class HadoopExecutorArguments
    extends ExecutorArguments {
        public HadoopExecutorArguments(long millisSinceEpoch, Path paramPath, Path designPath, Path destPath) {
            super(millisSinceEpoch);
            Path outputPath = designPath.getParent();
            Path jobPath = new Path(outputPath, this.getJobId());
            Path workingPath = new Path(jobPath, "working");
            Path taskPath = new Path(jobPath, "tasks");
            Path tmpDir = new Path(jobPath, "tmp");
            Path dataPath = new Path(outputPath, Globals.APP_NAME_LOWER_CASE + "-data");
            this.setJobPathname(jobPath.toString());
            this.setOutputPathname(outputPath.toString());
            this.setDesignPathname(designPath.toString());
            this.setWorkflowPathname(paramPath.toString());
            this.setLocalWorkingPathname(workingPath.toString());
            this.setTaskPathname(taskPath.toString());
            this.setHadoopWorkingPathname(destPath.toString());
            this.setDataPathname(dataPath.toString());
            this.setTemporaryPathname(tmpDir.toString());
        }
    }
}

