/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.actions;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.actions.AbstractInfoAction;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class FormatsAction
extends AbstractInfoAction {
    public static final String ACTION_NAME = "formats";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    protected void showInfo(Settings settings) {
        DataFormatRegistry registery = DataFormatRegistry.getInstance();
        StringBuilder sb = new StringBuilder();
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (DataFormat format : registery.getAllFormats()) {
            result.add(FormatsAction.infoFormat(format));
        }
        result.sort(Comparator.comparing(o -> (String)o.get(0)));
        List<String> columnNames = Arrays.asList("Name", "Aliases", "Extensions", "Prefix", "One file per analysis", "Description");
        List<Integer> maxLengths = FormatsAction.maxLengthKey(columnNames, result);
        for (int i = 0; i < columnNames.size(); ++i) {
            sb.append(Strings.padEnd((String)columnNames.get(i), (int)(maxLengths.get(i) + 2), (char)' '));
        }
        sb.append('\n');
        for (List list : result) {
            for (int i = 0; i < list.size(); ++i) {
                sb.append(Strings.padEnd((String)((String)list.get(i)), (int)(maxLengths.get(i) + 2), (char)' '));
            }
            sb.append('\n');
        }
        System.out.println();
        System.out.print(sb.toString());
    }

    private static List<String> infoFormat(DataFormat format) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(FormatsAction.null2Empty(format.getName()));
        HashSet<String> aliases = new HashSet<String>();
        if (format.getAlias() != null) {
            aliases.add(format.getAlias());
        }
        aliases.addAll(format.getGalaxyFormatNames());
        result.add(Joiner.on((String)", ").join(aliases));
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(format.getDefaultExtension());
        for (String s : format.getExtensions()) {
            if (extensions.contains(s)) continue;
            extensions.add(s);
        }
        result.add(Joiner.on((String)", ").join(extensions));
        result.add(FormatsAction.null2Empty(format.getPrefix()));
        result.add("" + format.isOneFilePerAnalysis());
        result.add(FormatsAction.null2Empty(format.getDescription()));
        return result;
    }

    private static String null2Empty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private static List<Integer> maxLengthKey(List<String> columnNames, List<List<String>> values) {
        ArrayList<Integer> result = null;
        ArrayList<List<String>> vals = new ArrayList<List<String>>(values);
        vals.add(columnNames);
        for (List list : vals) {
            if (result == null) {
                result = new ArrayList<Integer>(Collections.nCopies(list.size(), -1));
            }
            for (int j = 0; j < list.size(); ++j) {
                result.set(j, Math.max((Integer)result.get(j), ((String)list.get(j)).length()));
            }
        }
        return result;
    }
}

