/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.actions;

import com.google.common.base.Strings;
import fr.ens.biologie.genomique.eoulsan.Infos;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.actions.AbstractInfoAction;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InfoAction
extends AbstractInfoAction {
    public static final String ACTION_NAME = "info";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    protected void showInfo(Settings settings) {
        LinkedHashMap<String, List<Infos.Info>> sections = new LinkedHashMap<String, List<Infos.Info>>();
        sections.put("Software", Infos.softwareInfos(Main.getInstance()));
        sections.put("Command line", Infos.commandLineInfo(Main.getInstance()));
        sections.put("General configuration", Infos.generalConf(settings));
        sections.put("Modules and formats", Infos.modulesAndFormatsInfo(settings));
        sections.put("Storages", Infos.storageInfo(settings));
        sections.put("Cluster configuration", Infos.clusterInfo(settings));
        sections.put("Cloud configuration", Infos.cloudInfo(settings));
        sections.put("Docker", Infos.dockerInfo(settings));
        sections.put("R and RServe", Infos.rAndRserveInfo(settings));
        sections.put("Email", Infos.mailInfo(settings));
        sections.put("System configuration", Infos.systemInfos());
        sections.put("CPU", Infos.cpuInfo());
        sections.put("Memory", Infos.memInfo());
        sections.put("Partitions", Infos.partitionInfo(settings));
        System.out.println();
        System.out.print(InfoAction.infoToString(sections));
    }

    private static String infoToString(Map<String, List<Infos.Info>> sections) {
        StringBuilder sb = new StringBuilder();
        int maxLengthKey = InfoAction.maxLengthKey(sections) + 3;
        for (Map.Entry<String, List<Infos.Info>> e : sections.entrySet()) {
            sb.append(e.getKey());
            sb.append(':');
            sb.append('\n');
            for (Infos.Info i : e.getValue()) {
                sb.append("    ");
                sb.append(Strings.padEnd((String)(i.getName() + ":"), (int)maxLengthKey, (char)' '));
                boolean first = true;
                for (String v : i.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append("    ");
                        sb.append(Strings.padEnd((String)"", (int)maxLengthKey, (char)' '));
                    }
                    sb.append(v);
                    sb.append('\n');
                }
                if (!i.getValues().isEmpty()) continue;
                sb.append('\n');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static int maxLengthKey(List<Infos.Info> infos) {
        int result = -1;
        for (Infos.Info i : infos) {
            result = Math.max(result, i.getName().length());
        }
        return result;
    }

    private static int maxLengthKey(Map<String, List<Infos.Info>> sections) {
        int result = -1;
        for (List<Infos.Info> s : sections.values()) {
            result = Math.max(result, InfoAction.maxLengthKey(s));
        }
        return result;
    }
}

