/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.actions;

import com.google.common.base.Strings;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.actions.AbstractInfoAction;
import fr.ens.biologie.genomique.eoulsan.annotations.EoulsanAnnotationUtils;
import fr.ens.biologie.genomique.eoulsan.annotations.ExecutionMode;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ModuleRegistry;
import fr.ens.biologie.genomique.eoulsan.modules.GalaxyToolModule;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ModulesAction
extends AbstractInfoAction {
    public static final String ACTION_NAME = "modules";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    protected void showInfo(Settings settings) {
        ModuleRegistry registery = ModuleRegistry.getInstance();
        StringBuilder sb = new StringBuilder();
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (Module module : registery.getAllModules()) {
            if (module.getName().startsWith("_")) continue;
            result.add(ModulesAction.infoModule(module));
        }
        result.sort(Comparator.comparing(o -> (String)o.get(0)));
        List<String> columnNames = Arrays.asList("Name", "Version", "Type", "Generator", "Execution mode", "Description");
        List<Integer> maxLengths = ModulesAction.maxLengthKey(columnNames, result);
        for (int i = 0; i < columnNames.size(); ++i) {
            sb.append(Strings.padEnd((String)columnNames.get(i), (int)(maxLengths.get(i) + 2), (char)' '));
        }
        sb.append('\n');
        for (List list : result) {
            for (int i = 0; i < list.size(); ++i) {
                sb.append(Strings.padEnd((String)((String)list.get(i)), (int)(maxLengths.get(i) + 2), (char)' '));
            }
            sb.append('\n');
        }
        System.out.println();
        System.out.print(sb.toString());
    }

    private static List<String> infoModule(Module module) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(ModulesAction.null2Empty(module.getName()));
        Version v = module.getVersion();
        result.add(v == null ? "" : v.toString());
        if (module instanceof GalaxyToolModule) {
            result.add("galaxy tool");
        } else {
            result.add("java");
        }
        result.add("" + EoulsanAnnotationUtils.isGenerator(module));
        ExecutionMode mode = ExecutionMode.getExecutionMode(module.getClass());
        result.add(mode.toString().replace('_', ' ').toLowerCase());
        result.add(ModulesAction.null2Empty(module.getDescription()));
        return result;
    }

    private static String null2Empty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private static List<Integer> maxLengthKey(List<String> columnNames, List<List<String>> values) {
        ArrayList<Integer> result = null;
        ArrayList<List<String>> vals = new ArrayList<List<String>>(values);
        vals.add(columnNames);
        for (List list : vals) {
            if (result == null) {
                result = new ArrayList<Integer>(Collections.nCopies(list.size(), -1));
            }
            for (int j = 0; j < list.size(); ++j) {
                result.set(j, Math.max((Integer)result.get(j), ((String)list.get(j)).length()));
            }
        }
        return result;
    }
}

