/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.annotations;

import fr.ens.biologie.genomique.eoulsan.annotations.HadoopCompatible;
import fr.ens.biologie.genomique.eoulsan.annotations.HadoopOnly;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import java.lang.annotation.Annotation;

public enum ExecutionMode {
    NONE,
    LOCAL_ONLY,
    HADOOP_COMPATIBLE,
    HADOOP_ONLY;


    public Class<? extends Annotation> getAnnotationClass() {
        switch (this) {
            case LOCAL_ONLY: {
                return LocalOnly.class;
            }
            case HADOOP_COMPATIBLE: {
                return HadoopCompatible.class;
            }
            case HADOOP_ONLY: {
                return HadoopOnly.class;
            }
        }
        return null;
    }

    public boolean isLocalCompatible() {
        switch (this) {
            case LOCAL_ONLY: 
            case HADOOP_COMPATIBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isHadoopCompatible() {
        switch (this) {
            case HADOOP_COMPATIBLE: 
            case HADOOP_ONLY: {
                return true;
            }
        }
        return false;
    }

    public static boolean accept(Class<?> clazz, boolean hadoopMode) {
        if (clazz == null) {
            return false;
        }
        ExecutionMode mode = ExecutionMode.getExecutionMode(clazz);
        switch (mode) {
            case LOCAL_ONLY: {
                return !hadoopMode;
            }
            case HADOOP_COMPATIBLE: {
                return true;
            }
            case HADOOP_ONLY: {
                return hadoopMode;
            }
        }
        return false;
    }

    public static ExecutionMode getExecutionMode(Class<?> annotationClazz) {
        if (annotationClazz == null) {
            return null;
        }
        ExecutionMode result = null;
        for (ExecutionMode mode : ExecutionMode.values()) {
            Class<? extends Annotation> annotation = mode.getAnnotationClass();
            if (annotation == null || annotationClazz.getAnnotation(annotation) == null) continue;
            if (result != null) {
                throw new IllegalStateException("A class can not have more than one Eoulsan mode: " + annotationClazz.getName());
            }
            result = mode;
        }
        if (result == null) {
            return NONE;
        }
        return result;
    }
}

