/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.bio.io.hadoop;

import fr.ens.biologie.genomique.eoulsan.bio.io.hadoop.FastqLineRecordReader;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class FastqRecordReader
extends RecordReader<Text, Text> {
    private static final String COUNTERS_GROUP = "FASTQ Input Format Counters";
    private final TaskAttemptContext context;
    private Text key = new Text();
    private Text value = new Text();
    private final String[] lines = new String[4];
    private FastqLineRecordReader lrr;

    public synchronized void close() throws IOException {
        this.lrr.close();
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.lrr.getProgress();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.lrr = new FastqLineRecordReader();
        this.lrr.initialize(inputSplit, taskAttemptContext);
    }

    public synchronized boolean nextKeyValue() throws IOException, InterruptedException {
        int count = 0;
        boolean found = false;
        while (!found) {
            if (!this.lrr.nextKeyValue(count != 0)) {
                return false;
            }
            String s = this.lrr.getCurrentValue().toString().trim();
            if (s.length() == 0) continue;
            this.lines[count] = s;
            if (count < 3) {
                ++count;
                continue;
            }
            if (this.lines[0].charAt(0) == '@' && this.lines[2].charAt(0) == '+') {
                found = true;
                continue;
            }
            this.lines[0] = this.lines[1];
            this.lines[1] = this.lines[2];
            this.lines[2] = this.lines[3];
        }
        this.key = new Text(FastqRecordReader.memberId(this.lines[0].substring(1)));
        this.value = new Text(this.lines[0].substring(1) + "\t" + this.lines[1] + "\t" + this.lines[3]);
        this.lines[3] = null;
        this.lines[2] = null;
        this.lines[1] = null;
        this.lines[0] = null;
        this.context.getCounter(COUNTERS_GROUP, "Entries Written").increment(1L);
        return true;
    }

    private static String memberId(String s) {
        if (s == null) {
            return null;
        }
        int pos1 = s.indexOf(32);
        if (pos1 != -1) {
            return s.substring(0, pos1);
        }
        int pos2 = s.indexOf(47);
        if (pos2 != -1) {
            return s.substring(0, pos2);
        }
        return s;
    }

    public FastqRecordReader(TaskAttemptContext context) {
        this.context = context;
    }
}

