/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.bio.io.hadoop;

import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class FastqRecordWriter
extends RecordWriter<Text, Text> {
    private static final String COUNTERS_GROUP = "FASTQ Output Format Counters";
    private static final byte[] newline = "\n".getBytes(StandardCharsets.UTF_8);
    private final DataOutputStream out;
    private final TaskAttemptContext context;
    private final ReadSequence read = new ReadSequence();

    public synchronized void write(Text key, Text value) throws IOException {
        this.context.getCounter(COUNTERS_GROUP, "Input Entries").increment(1L);
        if (value == null) {
            return;
        }
        this.read.parse(value.toString());
        this.out.write(this.read.toFastQ().getBytes(StandardCharsets.UTF_8));
        this.out.write(newline);
        this.context.getCounter(COUNTERS_GROUP, "Entries Written").increment(1L);
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.out.close();
    }

    public FastqRecordWriter(TaskAttemptContext context, DataOutputStream out) {
        this.context = context;
        this.out = out;
    }
}

