/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.bio.io.hadoop;

import fr.ens.biologie.genomique.eoulsan.bio.io.hadoop.SAMRecordWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class SAMOutputFormat
extends FileOutputFormat<Text, Text> {
    public RecordWriter<Text, Text> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        boolean isCompressed = SAMOutputFormat.getCompressOutput((JobContext)context);
        CompressionCodec codec = null;
        String extension = "";
        if (isCompressed) {
            Class codecClass = SAMOutputFormat.getOutputCompressorClass((JobContext)context, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            extension = codec.getDefaultExtension();
        }
        Path file = this.getDefaultWorkFile(context, extension);
        FileSystem fs = file.getFileSystem(conf);
        if (!isCompressed) {
            FSDataOutputStream fileOut = fs.create(file, false);
            return new SAMRecordWriter(context, (DataOutputStream)fileOut);
        }
        FSDataOutputStream fileOut = fs.create(file, false);
        return new SAMRecordWriter(context, new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut)));
    }
}

