/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.bio.io.hadoop;

import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;

public class SAMRecordReader
extends RecordReader<Text, Text> {
    private static final String COUNTERS_GROUP = "SAM Input Format Counters";
    private final TaskAttemptContext context;
    private final LineRecordReader lrr = new LineRecordReader();
    private final Text key = new Text();
    private final Text value = new Text();

    public synchronized void close() throws IOException {
        this.lrr.close();
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.lrr.getProgress();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.lrr.initialize(inputSplit, taskAttemptContext);
    }

    public synchronized boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.lrr.nextKeyValue()) {
            return false;
        }
        Text value = this.lrr.getCurrentValue();
        if (value != null) {
            String s = value.toString();
            if (s.length() == 0) {
                this.key.set("");
                this.value.set("");
            } else {
                if (s.charAt(0) == '@') {
                    this.key.set("");
                } else {
                    int posFirstTab = s.indexOf(9);
                    if (posFirstTab == -1) {
                        this.key.set("");
                    } else {
                        this.key.set(s.substring(0, posFirstTab));
                    }
                }
                this.value.set(s);
            }
        }
        this.context.getCounter(COUNTERS_GROUP, "Entries Written").increment(1L);
        return true;
    }

    public SAMRecordReader(TaskAttemptContext context) {
        this.context = context;
    }
}

