/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.bio.io.hadoop;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class SAMRecordWriter
extends RecordWriter<Text, Text> {
    private static final String COUNTERS_GROUP = "SAM Output Format Counters";
    private static final byte[] newline = "\n".getBytes(StandardCharsets.UTF_8);
    private final DataOutputStream out;
    private final TaskAttemptContext context;

    public synchronized void write(Text key, Text value) throws IOException, InterruptedException {
        this.context.getCounter(COUNTERS_GROUP, "Input Entries").increment(1L);
        if (value == null) {
            return;
        }
        this.out.write(value.getBytes(), 0, value.getLength());
        this.out.write(newline);
        this.context.getCounter(COUNTERS_GROUP, "Entries Written").increment(1L);
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.out.close();
    }

    public SAMRecordWriter(TaskAttemptContext context, DataOutputStream out) {
        this.context = context;
        this.out = out;
    }
}

