/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.checkers;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.checkers.CheckStore;
import fr.ens.biologie.genomique.eoulsan.checkers.Checker;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentMetadata;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class DESeq2DesignChecker
implements Checker,
Serializable {
    private static final long serialVersionUID = -7079642248159153890L;

    @Override
    public String getName() {
        return "deseq2_design_checker";
    }

    @Override
    public boolean isDesignChecker() {
        return true;
    }

    @Override
    public DataFormat getFormat() {
        return null;
    }

    @Override
    public void configure(Set<Parameter> stepParameters) throws EoulsanException {
    }

    @Override
    public boolean check(Data data, CheckStore checkInfo) throws EoulsanException {
        Design design = (Design)checkInfo.get("design");
        for (Experiment e : design.getExperiments()) {
            if (DESeq2DesignChecker.checkExperimentDesign(e, true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<DataFormat> getCheckersRequired() {
        return Collections.emptySet();
    }

    public static boolean checkExperimentDesign(Experiment experiment) throws EoulsanException {
        return DESeq2DesignChecker.checkExperimentDesign(experiment, true);
    }

    /*
     * WARNING - void declaration
     */
    static boolean checkExperimentDesign(Experiment experiment, boolean throwsException) throws EoulsanException {
        Object s;
        Objects.requireNonNull(experiment, "Experiment argument cannot be null");
        ExperimentMetadata emd = experiment.getMetadata();
        Design design = experiment.getDesign();
        List<String> esColumnNames = DesignUtils.getExperimentSampleAllMetadataKeys(experiment);
        List<String> sColumnNames = DesignUtils.getAllSamplesMetadataKeys(design);
        ArrayList<String> allColumnNames = new ArrayList<String>(esColumnNames);
        allColumnNames.addAll(sColumnNames);
        for (String string : allColumnNames) {
            for (ExperimentSample experimentSample : experiment.getExperimentSamples()) {
                String value = DesignUtils.getMetadata(experimentSample, string);
                if (!Strings.isNullOrEmpty((String)value)) continue;
                return DESeq2DesignChecker.error("There is an empty cell" + experiment.getName(), throwsException);
            }
        }
        if (emd.containsComparisons()) {
            void var10_30;
            Iterator<Object> comparisionNames = new HashSet();
            String[] stringArray = emd.getComparisons().split(";");
            int n = stringArray.length;
            boolean bl = false;
            while (var10_30 < n) {
                String c = stringArray[var10_30];
                List splitC = Splitter.on((char)':').omitEmptyStrings().trimResults().splitToList((CharSequence)c);
                if (splitC.size() != 2) {
                    return DESeq2DesignChecker.error("Error in " + experiment.getName() + " experiment, comparison cannot have more than 1 value: " + c, throwsException);
                }
                String string = (String)splitC.get(1);
                if (string.equals("vs") || string.startsWith("_vs") || string.endsWith("vs_")) {
                    return DESeq2DesignChecker.error("Error in " + experiment.getName() + " experiment, the comparison string is badly written : " + c, throwsException);
                }
                if (!string.contains("_vs_")) {
                    comparisionNames.add(string);
                }
                HashSet<String> conditionsInComparisonString = new HashSet<String>(Arrays.asList(string.split("(%)|(_vs_)")));
                HashSet<CallSite> possibleConditions = new HashSet<CallSite>();
                for (String key : allColumnNames) {
                    for (ExperimentSample es2 : experiment.getExperimentSamples()) {
                        String string2 = DesignUtils.getMetadata(es2, key);
                        possibleConditions.add((CallSite)((Object)(key + string2)));
                    }
                }
                for (String condi : conditionsInComparisonString) {
                    Boolean exist = false;
                    for (String string3 : possibleConditions) {
                        if (!string3.equals(condi)) continue;
                        exist = true;
                    }
                    if (exist.booleanValue()) continue;
                    return DESeq2DesignChecker.error("Error in " + experiment.getName() + " experiment, one comparison (" + condi + ") does not exist: " + c, throwsException);
                }
                ++var10_30;
            }
            HashSet<String> hashSet = new HashSet<String>();
            HashSet duplicateElements = new HashSet();
            Iterator iterator = comparisionNames.iterator();
            while (iterator.hasNext()) {
                String element = (String)iterator.next();
                if (hashSet.add(element)) continue;
                duplicateElements.add(element);
            }
            if (!duplicateElements.isEmpty()) {
                return DESeq2DesignChecker.error("Error in " + experiment.getName() + " experiment, there is one or more duplicates in the comparison string names", throwsException);
            }
        }
        for (String string : DesignUtils.getModelColumns(experiment)) {
            for (ExperimentSample experimentSample : experiment.getExperimentSamples()) {
                String columnValue = DesignUtils.getMetadata(experimentSample, string);
                if (columnValue.isEmpty() || !Character.isDigit(columnValue.charAt(0))) continue;
                return DESeq2DesignChecker.error("The value of the \"" + string + "\" column start with a numeric character for \"" + experimentSample.getSample().getId() + "\" sample: " + columnValue, throwsException);
            }
        }
        for (String string : esColumnNames) {
            for (ExperimentSample experimentSample : experiment.getExperimentSamples()) {
                String s2 = DesignUtils.getMetadata(experimentSample, string);
                if (Pattern.matches("[a-zA-Z0-9\\_]+", s2) || !emd.isContrast()) continue;
                return DESeq2DesignChecker.error("There is an undesirable special character in the column " + string + " : " + s2, throwsException);
            }
        }
        if (sColumnNames.contains("Condition")) {
            for (ExperimentSample experimentSample : experiment.getExperimentSamples()) {
                s = DesignUtils.getMetadata(experimentSample, "Condition");
                if (((String)s).indexOf(45) == -1 || !emd.isContrast()) continue;
                return DESeq2DesignChecker.error("There is a - character in the column Condition : " + (String)s, throwsException);
            }
        }
        for (String string : esColumnNames) {
            for (ExperimentSample experimentSample : experiment.getExperimentSamples()) {
                String s2 = DesignUtils.getMetadata(experimentSample, string);
                if (emd.isContrast() || emd.containsComparisons() || Pattern.matches("^[a-zA-Z0-9\\+\\-\\&\\_\\/\\.\\[\\]]+$", s2)) continue;
                return DESeq2DesignChecker.error("There is a special character in the column " + string + " : " + s2, throwsException);
            }
        }
        if (sColumnNames.contains("Condition")) {
            for (ExperimentSample experimentSample : experiment.getExperimentSamples()) {
                s = DesignUtils.getMetadata(experimentSample, "Condition");
                if (emd.isContrast() || emd.containsComparisons() || Pattern.matches("^[a-zA-Z0-9\\+\\-\\&\\_\\/\\.\\[\\]]+$", (CharSequence)s)) continue;
                return DESeq2DesignChecker.error("There is a special character in the column Condition : " + (String)s, throwsException);
            }
        }
        if (!emd.containsComparisons() && esColumnNames.contains("Reference") && esColumnNames.contains("Condition")) {
            HashMap<String, String> lhm = new HashMap<String, String>();
            for (ExperimentSample es : experiment.getExperimentSamples()) {
                String string = DesignUtils.getMetadata(es, "Condition");
                String reference = DesignUtils.getMetadata(es, "Reference");
                if (string == null || reference == null || string.isEmpty() || reference.isEmpty()) {
                    return DESeq2DesignChecker.error("There is an empty condition or reference " + experiment.getName(), throwsException);
                }
                for (Map.Entry entry : lhm.entrySet()) {
                    if (!((String)entry.getKey()).equals(string) || ((String)entry.getValue()).equals(reference)) continue;
                    return DESeq2DesignChecker.error("There is an inconsistency between the conditions and the references: " + experiment.getName(), throwsException);
                }
                lhm.put(string, reference);
            }
        }
        ArrayListMultimap mapPossibleCombination = ArrayListMultimap.create();
        for (String key : allColumnNames) {
            for (ExperimentSample es : experiment.getExperimentSamples()) {
                String value = DesignUtils.getMetadata(es, key);
                mapPossibleCombination.put((Object)key, (Object)value);
            }
        }
        for (String key : mapPossibleCombination.keySet()) {
            for (String value : mapPossibleCombination.values()) {
                for (String string : mapPossibleCombination.keySet()) {
                    String keyValue = string + value;
                    if (!key.equals(value) && !keyValue.equals(key)) continue;
                    return DESeq2DesignChecker.error("There is an incoherence between the key and the values names" + experiment.getName(), throwsException);
                }
            }
        }
        if (!esColumnNames.contains("Condition") && !sColumnNames.contains("Condition")) {
            return DESeq2DesignChecker.error("Condition column missing for experiment: " + experiment.getName(), throwsException);
        }
        if (!esColumnNames.contains("RepTechGroup") && !sColumnNames.contains("RepTechGroup")) {
            return DESeq2DesignChecker.error("RepTechGroup column missing for experiment: " + experiment.getName(), throwsException);
        }
        return true;
    }

    private static boolean error(String message, boolean throwsException) throws EoulsanException {
        if (throwsException) {
            throw new EoulsanException(message);
        }
        return false;
    }
}

