/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.core.Port;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractPort
implements Port,
Serializable {
    private static final long serialVersionUID = 1773398938012180465L;
    private final String name;
    private final boolean list;
    private final DataFormat format;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isList() {
        return this.list;
    }

    @Override
    public DataFormat getFormat() {
        return this.format;
    }

    @Override
    public Set<Step> getLinkedSteps() {
        return Collections.emptySet();
    }

    AbstractPort(String name, boolean list, DataFormat format) {
        Objects.requireNonNull(name, "The name of the port is null");
        Objects.requireNonNull(format, "The format of the port " + name + " is null");
        Preconditions.checkArgument((boolean)FileNaming.isPortNameValid(name), (Object)("Invalid port name (only ascii letters and digits are allowed): " + name.trim()));
        this.name = name.trim().toLowerCase();
        this.list = list;
        this.format = format;
    }
}

