/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core;

import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.Port;
import fr.ens.biologie.genomique.eoulsan.core.Ports;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPorts<E extends Port>
implements Ports<E>,
Serializable {
    private static final long serialVersionUID = -5116830881426447140L;
    private final Map<String, E> ports;

    @Override
    public Iterator<E> iterator() {
        return this.ports.values().iterator();
    }

    @Override
    public E getPort(String name) {
        if (name == null) {
            return null;
        }
        return (E)((Port)this.ports.get(name.trim().toLowerCase()));
    }

    @Override
    public boolean contains(String name) {
        if (name == null) {
            return false;
        }
        return this.ports.containsKey(name.trim().toLowerCase());
    }

    @Override
    public boolean contains(E port) {
        if (port == null) {
            return false;
        }
        return this.ports.containsKey(port.getName());
    }

    @Override
    public Set<String> getPortNames() {
        return Collections.unmodifiableSet(this.ports.keySet());
    }

    @Override
    public int size() {
        return this.ports.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public E getFirstPort() {
        if (this.size() == 0) {
            return null;
        }
        return (E)((Port)this.iterator().next());
    }

    public String toString() {
        return this.ports.toString();
    }

    protected AbstractPorts(Set<E> ports) {
        if (ports == null || ports.isEmpty()) {
            this.ports = Collections.emptyMap();
            return;
        }
        HashMap<String, E> map = new HashMap<String, E>();
        for (Port port : ports) {
            if (port == null) continue;
            if (map.containsKey(port.getName())) {
                throw new EoulsanRuntimeException("A port already exists with the same name: " + port.getName());
            }
            map.put(port.getName(), port);
        }
        switch (map.size()) {
            case 0: {
                this.ports = Collections.emptyMap();
                break;
            }
            case 1: {
                Port value = (Port)map.values().iterator().next();
                this.ports = Collections.singletonMap(value.getName(), value);
                break;
            }
            default: {
                this.ports = map;
            }
        }
    }

    @Override
    public int countDataFormat(DataFormat format) {
        if (format == null) {
            return 0;
        }
        int count = 0;
        for (Port e : this) {
            if (!e.getFormat().equals(format)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<E> getPortsWithDataFormat(DataFormat format) {
        if (format == null) {
            return Collections.emptyList();
        }
        ArrayList<Port> result = new ArrayList<Port>();
        for (Port e : this) {
            if (!e.getFormat().equals(format)) continue;
            result.add(e);
        }
        return Collections.unmodifiableList(result);
    }
}

