/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core;

import fr.ens.biologie.genomique.eoulsan.core.InputPort;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.SimpleInputPort;
import fr.ens.biologie.genomique.eoulsan.core.SimpleInputPorts;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class InputPortsBuilder {
    public static final String DEFAULT_SINGLE_INPUT_PORT_NAME = "input";
    private final Set<InputPort> result = new HashSet<InputPort>();

    public InputPortsBuilder addPort(String name, DataFormat format) {
        return this.addPort(new SimpleInputPort(name, format));
    }

    public InputPortsBuilder addPort(String name, boolean list, DataFormat format) {
        return this.addPort(new SimpleInputPort(name, list, format));
    }

    public InputPortsBuilder addPort(String name, DataFormat format, EnumSet<CompressionType> compressionsAccepted) {
        return this.addPort(new SimpleInputPort(name, format, compressionsAccepted));
    }

    public InputPortsBuilder addPort(String name, boolean list, DataFormat format, EnumSet<CompressionType> compressionsAccepted) {
        return this.addPort(new SimpleInputPort(name, list, format, compressionsAccepted));
    }

    public InputPortsBuilder addPort(String name, DataFormat format, boolean requiredInWorkingDirectory) {
        return this.addPort(new SimpleInputPort(name, format, requiredInWorkingDirectory));
    }

    public InputPortsBuilder addPort(String name, boolean list, DataFormat format, boolean requiredInWorkingDirectory) {
        return this.addPort(new SimpleInputPort(name, list, format, requiredInWorkingDirectory));
    }

    public InputPortsBuilder addPort(String name, DataFormat format, EnumSet<CompressionType> compressionsAccepted, boolean requiredInWorkingDirectory) {
        return this.addPort(new SimpleInputPort(name, format, compressionsAccepted, requiredInWorkingDirectory));
    }

    public InputPortsBuilder addPort(String name, boolean list, DataFormat format, EnumSet<CompressionType> compressionsAccepted, boolean requiredInWorkingDirectory) {
        return this.addPort(new SimpleInputPort(name, list, format, compressionsAccepted, requiredInWorkingDirectory));
    }

    public InputPorts create() {
        return new SimpleInputPorts(this.result);
    }

    private InputPortsBuilder addPort(InputPort port) {
        this.result.add(port);
        return this;
    }

    public static InputPorts noInputPort() {
        return new SimpleInputPorts(null);
    }

    public static InputPorts singleInputPort(DataFormat format) {
        return new InputPortsBuilder().addPort(DEFAULT_SINGLE_INPUT_PORT_NAME, format).create();
    }

    public static InputPorts singleInputPort(String name, DataFormat format) {
        return new InputPortsBuilder().addPort(name, format).create();
    }

    public static InputPorts allPortsRequiredInWorkingDirectory(InputPorts inputPorts) {
        if (inputPorts == null) {
            return null;
        }
        InputPortsBuilder builder = new InputPortsBuilder();
        for (InputPort port : inputPorts) {
            builder.addPort(port.getName(), port.getFormat(), true);
        }
        return builder.create();
    }

    public static InputPorts copy(InputPorts ports) {
        if (ports == null) {
            return null;
        }
        InputPortsBuilder builder = new InputPortsBuilder();
        for (InputPort port : ports) {
            builder.addPort(port);
        }
        return builder.create();
    }
}

