/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core;

import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.OutputPort;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.SimpleOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.SimpleOutputPorts;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import java.util.HashSet;
import java.util.Set;

public class OutputPortsBuilder {
    public static final String DEFAULT_SINGLE_OUTPUT_PORT_NAME = "output";
    private final Set<OutputPort> result = new HashSet<OutputPort>();
    private final Set<String> portNames = new HashSet<String>();

    public OutputPortsBuilder addPort(String name, DataFormat format) {
        return this.addPort(new SimpleOutputPort(name, format));
    }

    public OutputPortsBuilder addPort(String name, boolean list, DataFormat format) {
        return this.addPort(new SimpleOutputPort(name, list, format));
    }

    public OutputPortsBuilder addPort(String name, DataFormat format, CompressionType compression) {
        return this.addPort(new SimpleOutputPort(name, format, compression));
    }

    public OutputPortsBuilder addPort(String name, boolean list, DataFormat format, CompressionType compression) {
        return this.addPort(new SimpleOutputPort(name, list, format, compression));
    }

    public OutputPorts create() {
        return new SimpleOutputPorts(this.result);
    }

    public static OutputPorts noOutputPort() {
        return new SimpleOutputPorts(null);
    }

    public static OutputPorts singleOutputPort(DataFormat format) {
        return new OutputPortsBuilder().addPort(DEFAULT_SINGLE_OUTPUT_PORT_NAME, format).create();
    }

    public static OutputPorts singleOutputPort(String name, DataFormat format) {
        return new OutputPortsBuilder().addPort(name, format).create();
    }

    public static OutputPorts copy(OutputPorts ports) {
        if (ports == null) {
            return null;
        }
        OutputPortsBuilder builder = new OutputPortsBuilder();
        for (OutputPort port : ports) {
            builder.addPort(port);
        }
        return builder.create();
    }

    private OutputPortsBuilder addPort(OutputPort port) {
        if (this.portNames.contains(port.getName())) {
            throw new EoulsanRuntimeException("Two output ports had the same name: " + port.getName());
        }
        this.result.add(port);
        this.portNames.add(port.getName());
        return this;
    }
}

