/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.checkers.Checker;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Workflow;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public interface Step
extends Serializable {
    public Workflow getWorkflow();

    public int getNumber();

    public String getId();

    public boolean isSkip();

    public StepType getType();

    public String getModuleName();

    public String getStepVersion();

    public Set<Parameter> getParameters();

    public int getRequiredMemory();

    public int getRequiredProcessors();

    public InputPorts getInputPorts();

    public OutputPorts getOutputPorts();

    public StepState getState();

    public Checker getChecker();

    public static enum StepState {
        CREATED,
        CONFIGURED,
        WAITING,
        READY,
        WORKING,
        PARTIALLY_DONE,
        DONE,
        FAILED,
        ABORTED;


        public boolean isFinalState() {
            return this == DONE || this == FAILED || this == ABORTED;
        }

        public boolean isWorkingState() {
            return this == WORKING || this == PARTIALLY_DONE;
        }

        public boolean isDoneState() {
            return this == PARTIALLY_DONE || this == DONE;
        }
    }

    public static enum DiscardOutput {
        NO,
        ASAP,
        SUCCESS;


        public boolean isCopyResultsToOutput() {
            return this == NO;
        }

        public static DiscardOutput parse(String s) throws EoulsanException {
            if (s == null) {
                throw new NullPointerException("s argument cannot be null");
            }
            switch (s.toLowerCase().trim()) {
                case "no": 
                case "false": 
                case "": {
                    return NO;
                }
                case "asap": {
                    return ASAP;
                }
                case "yes": 
                case "completed": 
                case "true": {
                    return SUCCESS;
                }
            }
            throw new EoulsanException("Unknown value for discardouput attribute: " + s);
        }
    }

    public static enum StepType {
        ROOT_STEP(0, "root"),
        DESIGN_STEP(1, "design"),
        CHECKER_STEP(2, "checker"),
        GENERATOR_STEP(3, null),
        FIRST_STEP(4, "first"),
        STANDARD_STEP(5, null),
        TERMINAL_STEP(6, "terminal");

        private final int priority;
        private final String defaultStepId;

        public int getPriority() {
            return this.priority;
        }

        public String getDefaultStepId() {
            return this.defaultStepId;
        }

        public static Set<String> getAllDefaultStepId() {
            HashSet<String> result = new HashSet<String>();
            for (StepType type : StepType.values()) {
                String stepId = type.getDefaultStepId();
                if (stepId == null) continue;
                result.add(stepId);
            }
            return result;
        }

        private StepType(int priority, String defaultStepId) {
            this.priority = priority;
            this.defaultStepId = defaultStepId;
        }
    }
}

