/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.schedulers;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.core.ParallelizationMode;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.AbstractTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.MonoThreadTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.MultiThreadTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.TaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.clusters.ClusterTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepResult;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepStatus;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import java.util.Objects;
import java.util.Set;

public class ClusterCombinedTaskScheduler
implements TaskScheduler {
    private final AbstractTaskScheduler noTaskScheduler;
    private final AbstractTaskScheduler stdTaskScheduler;
    private final AbstractTaskScheduler clusterTaskScheduler;
    private volatile boolean isStarted;
    private volatile boolean isStopped;

    @Override
    public void submit(Step step, Set<TaskContextImpl> contexts) {
        Objects.requireNonNull(contexts, "contexts argument cannot be null");
        this.checkExecutionState();
        for (TaskContextImpl context : contexts) {
            this.submit(step, context);
        }
    }

    @Override
    public void submit(Step step, TaskContextImpl context) {
        Objects.requireNonNull(step, "step argument cannot be null");
        Objects.requireNonNull(context, "context argument cannot be null");
        this.checkExecutionState();
        this.getTaskScheduler(step).submit(step, context);
    }

    @Override
    public StepStatus getStatus(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return this.getTaskScheduler(step).getStatus(step);
    }

    @Override
    public StepResult getResult(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return this.getTaskScheduler(step).getResult(step);
    }

    @Override
    public int getTaskSubmittedCount(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return this.getTaskScheduler(step).getTaskSubmittedCount(step);
    }

    @Override
    public int getTaskRunningCount(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return this.getTaskScheduler(step).getTaskRunningCount(step);
    }

    @Override
    public int getTaskDoneCount(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return this.getTaskScheduler(step).getTaskDoneCount(step);
    }

    @Override
    public void waitEndOfTasks(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        this.checkExecutionState();
        this.getTaskScheduler(step).waitEndOfTasks(step);
    }

    @Override
    public int getTotalTaskSubmittedCount() {
        return this.noTaskScheduler.getTotalTaskSubmittedCount() + this.stdTaskScheduler.getTotalTaskSubmittedCount() + this.clusterTaskScheduler.getTotalTaskSubmittedCount();
    }

    @Override
    public int getTotalTaskRunningCount() {
        return this.noTaskScheduler.getTotalTaskRunningCount() + this.stdTaskScheduler.getTotalTaskRunningCount() + this.clusterTaskScheduler.getTotalTaskRunningCount();
    }

    @Override
    public int getTotalTaskDoneCount() {
        return this.noTaskScheduler.getTotalTaskDoneCount() + this.stdTaskScheduler.getTotalTaskDoneCount() + this.clusterTaskScheduler.getTotalTaskDoneCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        ClusterCombinedTaskScheduler clusterCombinedTaskScheduler = this;
        synchronized (clusterCombinedTaskScheduler) {
            Preconditions.checkState((!this.isStopped ? 1 : 0) != 0, (Object)"The scheduler is stopped");
            this.isStarted = true;
        }
        this.noTaskScheduler.start();
        this.stdTaskScheduler.start();
        this.clusterTaskScheduler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.checkExecutionState();
        ClusterCombinedTaskScheduler clusterCombinedTaskScheduler = this;
        synchronized (clusterCombinedTaskScheduler) {
            this.isStopped = true;
        }
        this.noTaskScheduler.stop();
        this.stdTaskScheduler.stop();
        this.clusterTaskScheduler.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExecutionState() {
        ClusterCombinedTaskScheduler clusterCombinedTaskScheduler = this;
        synchronized (clusterCombinedTaskScheduler) {
            Preconditions.checkState((boolean)this.isStarted, (Object)"The scheduler is not started");
            Preconditions.checkState((!this.isStopped ? 1 : 0) != 0, (Object)"The scheduler is stopped");
        }
    }

    private static ParallelizationMode getParallelizationMode(Step step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        return ((AbstractStep)step).getParallelizationMode();
    }

    private TaskScheduler getTaskScheduler(Step step) {
        if (step.getType() == Step.StepType.GENERATOR_STEP) {
            return this.stdTaskScheduler;
        }
        switch (ClusterCombinedTaskScheduler.getParallelizationMode(step)) {
            case NOT_NEEDED: {
                return this.noTaskScheduler;
            }
            case STANDARD: 
            case OWN_PARALLELIZATION: {
                return this.clusterTaskScheduler;
            }
        }
        throw new IllegalStateException("Unknown Parallelization mode");
    }

    public ClusterCombinedTaskScheduler(int threadNumber, ClusterTaskScheduler clusterScheduler) {
        Objects.requireNonNull(clusterScheduler, "clusterScheduler argument cannot be null");
        this.noTaskScheduler = new MonoThreadTaskScheduler();
        this.stdTaskScheduler = new MultiThreadTaskScheduler(threadNumber);
        this.clusterTaskScheduler = (AbstractTaskScheduler)((Object)clusterScheduler);
    }
}

