/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.schedulers;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.AbstractTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.PausableThreadPoolExecutor;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskResultImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class MultiThreadTaskScheduler
extends AbstractTaskScheduler
implements Runnable {
    private static final int SLEEP_TIME_IN_MS = 500;
    private static final int WAIT_SHUTDOWN_MINUTES = 60;
    private final PausableThreadPoolExecutor executor;
    private final Set<Future<TaskThread>> threads = new HashSet<Future<TaskThread>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Step step, TaskContextImpl context) {
        super.submit(step, context);
        TaskThread st = new TaskThread(context);
        int requiredProcessors = context.getCurrentStep().getRequiredProcessors();
        Set<Future<TaskThread>> set = this.threads;
        synchronized (set) {
            this.threads.add(this.executor.submit(st, st, requiredProcessors));
        }
    }

    @Override
    public void start() {
        super.start();
        new Thread((Runnable)this, "TaskScheduler_multi_thread").start();
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            EoulsanLogger.getLogger().severe(e.getMessage());
        }
    }

    @Override
    public void pause() {
        super.pause();
        this.executor.pause();
    }

    @Override
    public void resume() {
        super.resume();
        this.executor.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Future<TaskThread>> threadsToRemove = new ArrayList<Future<TaskThread>>();
        while (!this.isStopped()) {
            for (Future<TaskThread> ftt : this.threads) {
                if (!ftt.isDone()) continue;
                try {
                    TaskThread taskThread = ftt.get();
                    if (!taskThread.done) {
                        taskThread.fail(ftt.isCancelled());
                    }
                    threadsToRemove.add(ftt);
                }
                catch (InterruptedException | ExecutionException exception) {
                    EoulsanLogger.getLogger().severe("Unexcepted exception in " + this.getClass().getSimpleName() + ".run(): " + exception.getMessage());
                }
            }
            if (!this.threads.isEmpty()) {
                ArrayList<Future<TaskThread>> arrayList = threadsToRemove;
                synchronized (arrayList) {
                    for (Future future : threadsToRemove) {
                        this.threads.remove(future);
                    }
                }
                threadsToRemove.clear();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                EoulsanLogger.getLogger().severe(e.getMessage());
            }
        }
    }

    public MultiThreadTaskScheduler(int threadNumber) {
        Preconditions.checkArgument((threadNumber > 0 ? 1 : 0) != 0, (Object)"threadNumber must be > 0");
        this.executor = new PausableThreadPoolExecutor(threadNumber);
    }

    private final class TaskThread
    implements Runnable {
        private final TaskContextImpl context;
        private final long submissionTime;
        private Throwable e;
        private boolean done;

        @Override
        public void run() {
            try {
                if (MultiThreadTaskScheduler.this.isStopped()) {
                    this.done = true;
                    return;
                }
                MultiThreadTaskScheduler.this.beforeExecuteTask(this.context);
                TaskResultImpl result = MultiThreadTaskScheduler.this.executeTask(this.context);
                if (MultiThreadTaskScheduler.this.isStopped()) {
                    this.done = true;
                    return;
                }
                MultiThreadTaskScheduler.this.afterExecuteTask(this.context, result);
                this.done = true;
            }
            catch (Throwable e) {
                this.e = e;
            }
        }

        public void fail(boolean cancel) {
            long endTime = System.currentTimeMillis();
            Throwable exception = this.e != null ? this.e : new EoulsanRuntimeException("Task #" + this.context.getId() + "has failed without exception, cancel=" + cancel);
            TaskResultImpl result = new TaskResultImpl(this.context, new Date(this.submissionTime), new Date(endTime), endTime - this.submissionTime, exception, exception.getMessage());
            MultiThreadTaskScheduler.this.afterExecuteTask(this.context, result);
        }

        TaskThread(TaskContextImpl context) {
            this.context = context;
            this.submissionTime = System.currentTimeMillis();
        }
    }
}

