/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.schedulers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class PausableThreadPoolExecutor
extends ThreadPoolExecutor {
    private boolean isPaused;
    private final ReentrantLock pauseLock = new ReentrantLock();
    private final Condition unPaused = this.pauseLock.newCondition();
    private final int maxThreads;
    private volatile int threadsAvailable;
    private final Map<Future<?>, Integer> requirements = new ConcurrentHashMap();

    public <T> Future<T> submit(Runnable task, T result, int requiredProcessors) {
        int requiredThreads = requiredProcessors < 1 ? 1 : Math.min(requiredProcessors, this.maxThreads);
        Future<T> submitResult = super.submit(task, result);
        this.requirements.put(submitResult, requiredThreads);
        return submitResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        while (!this.requirements.containsKey(r)) {
            PausableThreadPoolExecutor.sleep();
        }
        int requiredThreads = this.requirements.get(r);
        this.pauseLock.lock();
        try {
            while (this.isPaused) {
                this.unPaused.await();
            }
        }
        catch (InterruptedException ie) {
            t.interrupt();
        }
        finally {
            this.pauseLock.unlock();
        }
        while (this.threadsAvailable - requiredThreads < 0) {
            PausableThreadPoolExecutor.sleep();
        }
        PausableThreadPoolExecutor pausableThreadPoolExecutor = this;
        synchronized (pausableThreadPoolExecutor) {
            this.threadsAvailable -= requiredThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable task, Throwable t) {
        int requiredThreads = this.requirements.get(task);
        PausableThreadPoolExecutor pausableThreadPoolExecutor = this;
        synchronized (pausableThreadPoolExecutor) {
            this.threadsAvailable += requiredThreads;
        }
        this.requirements.remove(task);
        super.afterExecute(task, t);
    }

    public void pause() {
        this.pauseLock.lock();
        try {
            this.isPaused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void resume() {
        this.pauseLock.lock();
        try {
            this.isPaused = false;
            this.unPaused.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    private static void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public PausableThreadPoolExecutor(int threadNumber) {
        super(threadNumber, threadNumber, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.threadsAvailable = this.maxThreads = threadNumber < 1 ? 1 : threadNumber;
    }
}

