/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.schedulers.clusters;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.clusters.AbstractClusterTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.clusters.ClusterJobEmergencyStopTask;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.clusters.ClusterTaskScheduler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class BpipeTaskScheduler
extends AbstractClusterTaskScheduler {
    private static final int MAX_JOB_STATUS_ATTEMPTS = 3;

    protected abstract File getBpipeCommandWrapper();

    @Override
    public void configure(Settings settings) throws EoulsanException {
    }

    @Override
    public synchronized String submitJob(String jobName, List<String> jobCommand, File jobDirectory, int taskId, int requiredMemory, int requiredProcessors) throws IOException {
        Objects.requireNonNull(jobName, "jobName argument cannot be null");
        Objects.requireNonNull(jobCommand, "jobCommand argument cannot be null");
        Objects.requireNonNull(jobDirectory, "jobDirectory argument cannot be null");
        Preconditions.checkArgument((boolean)jobDirectory.isDirectory(), (Object)("The job directory does not exists or is not a directory: " + jobDirectory));
        String jobCommandString = Joiner.on((char)' ').join(jobCommand);
        try {
            Process process = this.startJobProcess(jobName, jobCommandString, jobDirectory, taskId, requiredMemory, requiredProcessors);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String jobId = reader.readLine();
            reader.close();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                EoulsanLogger.getLogger().fine("Job " + jobId + " submitted to " + this.getSchedulerName() + " scheduler. Job name: " + jobName + " Job command: " + jobCommand);
                ClusterJobEmergencyStopTask.addHadoopJobEmergencyStopTask(this, jobId);
                return jobId;
            }
            EoulsanLogger.getLogger().warning("Job submission failed with " + this.getSchedulerName() + " scheduler. Job name: " + jobName + " Job command: " + jobCommand);
            throw new IOException("Job submission failed, exit code: " + exitCode);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void stopJob(String jobId) throws IOException {
        Objects.requireNonNull(jobId, "jobId argument cannot be null");
        try {
            Process process = this.stopJobProcess(jobId);
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                EoulsanLogger.getLogger().fine("Job " + jobId + " removed from " + this.getSchedulerName() + " cluster");
            } else {
                EoulsanLogger.getLogger().warning("Job " + jobId + " not removed from " + this.getSchedulerName() + " cluster");
            }
        }
        catch (InterruptedException e) {
            EoulsanLogger.getLogger().severe(e.getMessage());
        }
    }

    @Override
    public ClusterTaskScheduler.StatusResult statusJob(String jobId) throws IOException {
        return this.statusJob(jobId, 0);
    }

    private ClusterTaskScheduler.StatusResult statusJob(String jobId, int callCount) throws IOException {
        Objects.requireNonNull(jobId, "jobId argument cannot be null");
        if (callCount == 3) {
            throw new IOException("Job status failed for job " + jobId + " after 3 multiple attempts, exit code: 0");
        }
        if (callCount > 0) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            String jobStatus;
            Process process = this.statusJobProcess(jobId);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                jobStatus = reader.readLine();
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                if (jobStatus == null || jobStatus.trim().isEmpty()) {
                    EoulsanLogger.getLogger().fine("Job " + jobId + " status on " + this.getSchedulerName() + " scheduler. Job status: " + jobStatus + " (try " + (callCount + 1) + ")");
                    return this.statusJob(jobId, callCount + 1);
                }
                EoulsanLogger.getLogger().fine("Job " + jobId + " status on " + this.getSchedulerName() + " scheduler. Job status: " + jobStatus);
                ArrayList fields = Lists.newArrayList((Iterable)Splitter.on((char)' ').split((CharSequence)jobStatus.trim()));
                switch ((String)fields.get(0)) {
                    case "WAITING": {
                        return new ClusterTaskScheduler.StatusResult(ClusterTaskScheduler.StatusValue.WAITING);
                    }
                    case "RUNNING": {
                        return new ClusterTaskScheduler.StatusResult(ClusterTaskScheduler.StatusValue.RUNNING);
                    }
                    case "COMPLETE": {
                        ClusterJobEmergencyStopTask.removeHadoopJobEmergencyStopTask(this, jobId);
                        if (fields.size() != 2) {
                            throw new IOException("Invalid complete string for job " + jobId + ": " + jobStatus);
                        }
                        try {
                            return new ClusterTaskScheduler.StatusResult(ClusterTaskScheduler.StatusValue.COMPLETE, Integer.parseInt((String)fields.get(1)));
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Invalid complete string for job " + jobId + ": " + jobStatus, e);
                        }
                    }
                    case "UNKNOWN": {
                        return new ClusterTaskScheduler.StatusResult(ClusterTaskScheduler.StatusValue.UNKNOWN);
                    }
                }
                throw new IOException("Unknown status: " + jobStatus);
            }
            EoulsanLogger.getLogger().warning("Job status command failed for job " + jobId + ". Exit code: " + exitCode);
            throw new IOException("Job status failed for job " + jobId + ", exit code: " + exitCode);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void cleanupJob(String jobId) throws IOException {
    }

    private Process startJobProcess(String jobName, String jobCommand, File jobDirectory, int taskId, int requiredMemory, int requiredProcessors) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getBpipeCommandWrapperPath());
        command.add("start");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.environment().put("NAME", jobName);
        builder.environment().put("COMMAND", jobCommand);
        builder.environment().put("JOBDIR", jobDirectory.getAbsolutePath());
        builder.environment().put("EOULSAN_TASK_ID", "" + taskId);
        builder.environment().putAll(this.additionalScriptEnvironment());
        if (builder.environment().containsKey("DISPLAY")) {
            builder.environment().remove("DISPLAY");
        }
        if (requiredMemory > 0) {
            int memory = requiredMemory / 1024 + (requiredMemory % 1024 == 0 ? 0 : 1);
            builder.environment().put("MEMORY", "" + memory);
        }
        if (requiredProcessors > 0) {
            builder.environment().put("PROCS", "" + requiredProcessors);
        }
        return builder.start();
    }

    private Process stopJobProcess(String jobId) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getBpipeCommandWrapperPath());
        command.add("stop");
        command.add(jobId);
        ProcessBuilder builder = new ProcessBuilder(command);
        return builder.start();
    }

    private Process statusJobProcess(String jobId) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getBpipeCommandWrapperPath());
        command.add("status");
        command.add(jobId);
        ProcessBuilder builder = new ProcessBuilder(command);
        return builder.start();
    }

    private String getBpipeCommandWrapperPath() throws IOException {
        File f = this.getBpipeCommandWrapper();
        if (f == null) {
            throw new IOException("No Bpipe command wrapper defined for scheduler " + this.getSchedulerName());
        }
        if (!f.exists()) {
            throw new IOException("The Bpipe command wrapper defines for scheduler " + this.getSchedulerName() + " does not exist: " + f);
        }
        if (!f.canExecute()) {
            throw new IOException("The Bpipe command wrapper defines for scheduler " + this.getSchedulerName() + " does not exist: " + f);
        }
        return f.getAbsolutePath();
    }

    protected Map<String, String> additionalScriptEnvironment() {
        return Collections.emptyMap();
    }
}

