/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.schedulers.clusters;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.clusters.ClusterTaskScheduler;
import fr.ens.biologie.genomique.eoulsan.core.workflow.EmergencyStopTask;
import fr.ens.biologie.genomique.eoulsan.core.workflow.EmergencyStopTasks;
import java.io.IOException;
import java.util.Objects;

public class ClusterJobEmergencyStopTask
implements EmergencyStopTask {
    private final ClusterTaskScheduler scheduler;
    private final String jobId;

    @Override
    public void stop() {
        EoulsanLogger.getLogger().info("Try to kill " + this.jobId + " " + this.scheduler.getSchedulerName() + " job");
        try {
            this.scheduler.statusJob(this.jobId);
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().severe(e.getMessage());
        }
        EoulsanLogger.getLogger().info(this.scheduler.getSchedulerName() + " job " + this.jobId + " killed");
    }

    public int hashCode() {
        return this.jobId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClusterJobEmergencyStopTask)) {
            return false;
        }
        ClusterJobEmergencyStopTask that = (ClusterJobEmergencyStopTask)obj;
        return this.jobId.equals(that.jobId);
    }

    public static void addHadoopJobEmergencyStopTask(ClusterTaskScheduler scheduler, String jobId) {
        EmergencyStopTasks.getInstance().add(new ClusterJobEmergencyStopTask(scheduler, jobId));
    }

    public static void removeHadoopJobEmergencyStopTask(ClusterTaskScheduler scheduler, String jobId) {
        EmergencyStopTasks.getInstance().remove(new ClusterJobEmergencyStopTask(scheduler, jobId));
    }

    public ClusterJobEmergencyStopTask(ClusterTaskScheduler scheduler, String jobId) {
        Objects.requireNonNull(scheduler, "scheduler argument cannot be null");
        Objects.requireNonNull(jobId, "jobId argument cannot be null");
        this.scheduler = scheduler;
        this.jobId = jobId;
    }
}

