/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.schedulers.clusters;

import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.clusters.BundledScriptBpipeTaskScheduler;
import java.util.HashMap;
import java.util.Map;

public class HTCondorTaskScheduler
extends BundledScriptBpipeTaskScheduler {
    public static final String SCHEDULER_NAME = "htcondor";
    private static final String COMMAND_WRAPPER_SCRIPT = "bpipe-htcondor.sh";
    private final String concurrencyLimits = EoulsanRuntime.getRuntime().getSettings().getSetting("htcondor.concurrency.limits");
    private final String accountingGroup;
    private final boolean niceUser = EoulsanRuntime.getRuntime().getSettings().getBooleanSetting("htcondor.nice.user");

    @Override
    protected Map<String, String> additionalScriptEnvironment() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("NICE_USER", this.niceUser ? "True" : "False");
        if (this.concurrencyLimits != null) {
            result.put("CONCURRENCY_LIMITS", this.concurrencyLimits);
        }
        if (this.accountingGroup != null) {
            result.put("ACCOUNTING_GROUP", this.accountingGroup);
        }
        return result;
    }

    public HTCondorTaskScheduler() {
        super(SCHEDULER_NAME, COMMAND_WRAPPER_SCRIPT);
        this.accountingGroup = EoulsanRuntime.getRuntime().getSettings().getSetting("htcondor.accounting.group");
    }
}

