/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

abstract class AbstractData
implements Data,
Serializable {
    private static final long serialVersionUID = 2363270050921101143L;
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private final int id;
    private String name;
    private boolean defaultName = true;
    private final DataFormat format;
    private int part = -1;

    @Override
    public String getName() {
        if (this.name == null) {
            return "data" + this.id;
        }
        return this.name;
    }

    @Override
    public DataFormat getFormat() {
        return this.format;
    }

    @Override
    public int getPart() {
        return this.part;
    }

    @Override
    public int size() {
        return this.getListElements().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getListElements().isEmpty();
    }

    void setName(String name) {
        this.setName(name, false);
    }

    void setName(String name, boolean defaultName) {
        Objects.requireNonNull(name, "The name of the data cannot be null");
        Preconditions.checkArgument((boolean)FileNaming.isDataNameValid(name), (Object)("The name of data can only contains letters and digit: " + name));
        this.name = name;
        this.defaultName = defaultName;
    }

    void setPart(int part) {
        Preconditions.checkArgument((part >= -1 ? 1 : 0) != 0, (Object)"Part argument must equals or greater tha -1");
        this.part = part;
    }

    boolean isDefaultName() {
        return this.defaultName;
    }

    boolean isNameSet() {
        return this.name != null;
    }

    protected AbstractData(DataFormat format) {
        Objects.requireNonNull(format, "format argument cannot be null");
        this.id = instanceCount.incrementAndGet();
        this.name = "data" + this.id;
        this.format = format;
    }

    protected AbstractData(AbstractData data) {
        Objects.requireNonNull(data, "data argument cannot be null");
        this.id = data.id;
        this.name = data.name;
        this.defaultName = data.defaultName;
        this.format = data.format;
        this.part = data.part;
    }
}

