/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.data.DataMetadata;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import java.io.Serializable;
import java.util.Objects;

abstract class AbstractDataMetadata
implements DataMetadata,
Serializable {
    private static final long serialVersionUID = -6869029697238897073L;

    AbstractDataMetadata() {
    }

    @Override
    public boolean isPairedEnd() {
        if (!this.containsKey("pairedend")) {
            return false;
        }
        return Boolean.parseBoolean(this.get("pairedend"));
    }

    @Override
    public void setPairedEnd(boolean pairedEnd) {
        this.set("pairedend", Boolean.toString(pairedEnd));
    }

    @Override
    public FastqFormat getFastqFormat() {
        return this.getFastqFormat(FastqFormat.FASTQ_SANGER);
    }

    @Override
    public FastqFormat getFastqFormat(FastqFormat defaultValue) {
        if (!this.containsKey("FastqFormat")) {
            return defaultValue;
        }
        FastqFormat result = FastqFormat.getFormatFromName((String)this.get("FastqFormat"));
        return result == null ? defaultValue : result;
    }

    @Override
    public void setFastqFormat(FastqFormat fastqFormat) {
        Objects.requireNonNull(fastqFormat, "fastqFormat argument cannot be null");
        this.set("FastqFormat", fastqFormat.getName());
    }

    @Override
    public String getSampleName() {
        return this.get("SampleName");
    }

    @Override
    public void setSampleName(String sampleName) {
        Objects.requireNonNull(sampleName, "sampleName argument cannot be null");
        this.set("SampleName", sampleName);
    }

    @Override
    public String getSampleId() {
        if (!this.containsKey("SampleId")) {
            return null;
        }
        return this.get("SampleId");
    }

    @Override
    public void setSampleId(String sampleId) {
        Objects.requireNonNull(sampleId, "sampleId argument cannot be null");
        this.set("SampleId", sampleId);
    }

    @Override
    public int getSampleNumber() {
        if (!this.containsKey("SampleNumber")) {
            return -1;
        }
        try {
            return Integer.parseInt(this.get("SampleNumber"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public void setSampleNumber(int sampleNumber) {
        Preconditions.checkArgument((sampleNumber > 0 ? 1 : 0) != 0, (Object)("sampleNumber argument must be greater than 0: " + sampleNumber));
        this.set("SampleNumber", Integer.toString(sampleNumber));
    }
}

