/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.annotations.EoulsanAnnotationUtils;
import fr.ens.biologie.genomique.eoulsan.annotations.ExecutionMode;
import fr.ens.biologie.genomique.eoulsan.checkers.Checker;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.ParallelizationMode;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.Workflow;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractWorkflow;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataProduct;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DefaultDataProduct;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepConfigurationContextImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPorts;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInstances;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputDirectory;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepStateDependencies;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowEventBus;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.modules.CheckerModule;
import fr.ens.biologie.genomique.eoulsan.modules.DesignModule;
import fr.ens.biologie.genomique.eoulsan.modules.FakeModule;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractStep
implements Step {
    private static final long serialVersionUID = 2040628014465126384L;
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private final AbstractWorkflow workflow;
    private final int number;
    private final String id;
    private final String version;
    private final Step.StepType type;
    private final Set<Parameter> parameters;
    private final Checker checker;
    private ParallelizationMode parallelizationMode = ParallelizationMode.STANDARD;
    private InputPorts inputPortsParameter = InputPortsBuilder.noInputPort();
    private OutputPorts outputPortsParameter = OutputPortsBuilder.noOutputPort();
    private final String moduleName;
    private final ExecutionMode mode;
    private boolean skip;
    private final Step.DiscardOutput discardOutput;
    private final boolean terminalStep;
    private final boolean createLogFiles;
    private final int requiredMemory;
    private final int requiredProcessors;
    private StepOutputPorts outputPorts = StepOutputPorts.noOutputPort();
    private StepInputPorts inputPorts = StepInputPorts.noInputPort();
    private final DataProduct dataProduct = new DefaultDataProduct();
    private final String dataProductConfiguration;
    private final StepStateDependencies stepStateDependencies;
    private final DataFile outputDir;

    @Override
    public Workflow getWorkflow() {
        return this.workflow;
    }

    AbstractWorkflow getAbstractWorkflow() {
        return this.workflow;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getStepVersion() {
        return this.version;
    }

    @Override
    public boolean isSkip() {
        return this.skip;
    }

    protected boolean isTerminalStep() {
        return this.terminalStep;
    }

    @Override
    public Step.StepType getType() {
        return this.type;
    }

    public Module getModule() {
        if (this.moduleName == null) {
            return null;
        }
        return StepInstances.getInstance().getModule(this);
    }

    public ExecutionMode getEoulsanMode() {
        return this.mode;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public Step.StepState getState() {
        return this.stepStateDependencies != null ? this.stepStateDependencies.getState() : null;
    }

    @Override
    public Set<Parameter> getParameters() {
        return Collections.unmodifiableSet(this.parameters);
    }

    @Override
    public InputPorts getInputPorts() {
        return this.inputPortsParameter;
    }

    @Override
    public OutputPorts getOutputPorts() {
        return this.outputPortsParameter;
    }

    @Override
    public int getRequiredMemory() {
        return this.requiredMemory;
    }

    @Override
    public int getRequiredProcessors() {
        return this.requiredProcessors;
    }

    @Override
    public Checker getChecker() {
        return this.checker;
    }

    StepInputPorts getWorkflowInputPorts() {
        return this.inputPorts;
    }

    StepOutputPorts getWorkflowOutputPorts() {
        return this.outputPorts;
    }

    public DataFile getStepOutputDirectory() {
        return this.outputDir;
    }

    boolean isCreateLogFiles() {
        return this.createLogFiles;
    }

    StepStateDependencies getStepStateDependencies() {
        return this.stepStateDependencies;
    }

    public ParallelizationMode getParallelizationMode() {
        return this.parallelizationMode;
    }

    DataProduct getDataProduct() {
        return this.dataProduct;
    }

    public Step.DiscardOutput getDiscardOutput() {
        return this.discardOutput;
    }

    private void setState(Step.StepState state) {
        Objects.requireNonNull(state, "state argument cannot be null");
        WorkflowEventBus.getInstance().postStepStateChange(this, state);
    }

    void setSkipped(boolean skipped) {
        Preconditions.checkArgument((this.type == Step.StepType.GENERATOR_STEP ? 1 : 0) != 0, (Object)("The step is not a generator and cannot be skipped: " + this.getId()));
        this.skip = skipped;
    }

    protected void registerInputAndOutputPorts(Module module) {
        Objects.requireNonNull(module, "module cannot be null");
        this.outputPortsParameter = module.getOutputPorts();
        if (this.outputPorts != null) {
            this.outputPorts = new StepOutputPorts(this, this.outputPortsParameter);
        }
        this.inputPortsParameter = module.getInputPorts();
        if (this.inputPorts != null) {
            this.inputPorts = new StepInputPorts(this, this.inputPortsParameter);
        }
    }

    protected void addDependency(StepInputPort inputPort, StepOutputPort dependencyOutputPort) {
        Objects.requireNonNull(inputPort, "inputPort argument cannot be null");
        Objects.requireNonNull(dependencyOutputPort, "dependencyOutputPort argument cannot be null");
        AbstractStep step = inputPort.getStep();
        AbstractStep dependencyStep = dependencyOutputPort.getStep();
        Preconditions.checkArgument((step == this ? 1 : 0) != 0, (Object)("input port (" + inputPort.getName() + ") is not a port of the step (" + this.getId() + ")"));
        inputPort.setLink(dependencyOutputPort);
        dependencyOutputPort.addLink(inputPort);
        step.addDependency(dependencyStep);
    }

    protected void addDependency(AbstractStep step) {
        Objects.requireNonNull(step, "step argument cannot be null");
        if (step == this) {
            throw new EoulsanRuntimeException("a step cannot depends on itself: " + step.getId());
        }
        if (this.getWorkflow() != step.getWorkflow()) {
            throw new EoulsanRuntimeException("step dependency is not in the same workflow");
        }
        this.stepStateDependencies.addDependency(step);
    }

    protected void configure() throws EoulsanException {
        if (this.getState() != Step.StepState.CREATED) {
            throw new IllegalStateException("Illegal step state for configuration: " + this.getState());
        }
        if (this.getType() == Step.StepType.STANDARD_STEP || this.getType() == Step.StepType.DESIGN_STEP || this.getType() == Step.StepType.GENERATOR_STEP || this.getType() == Step.StepType.CHECKER_STEP) {
            EoulsanLogger.getLogger().info("Configure " + this.getId() + " step with step parameters: " + this.getParameters());
            Module module = this.getModule();
            if (this.getType() == Step.StepType.STANDARD_STEP || this.getType() == Step.StepType.DESIGN_STEP || EoulsanAnnotationUtils.isGenerator(module)) {
                module.configure(new StepConfigurationContextImpl(this), this.getParameters());
                this.parallelizationMode = AbstractStep.getParallelizationMode(module);
            }
            this.registerInputAndOutputPorts(module);
        }
        this.dataProduct.configure(this.dataProductConfiguration);
        EoulsanLogger.getLogger().info("Use " + this.dataProduct.getName() + " data product for " + this.getId() + " step");
        this.setState(Step.StepState.CONFIGURED);
    }

    private static ParallelizationMode getParallelizationMode(Module module) {
        ParallelizationMode mode;
        if (module != null && (mode = module.getParallelizationMode()) != null) {
            return mode;
        }
        return ParallelizationMode.STANDARD;
    }

    AbstractStep(AbstractWorkflow workflow, Step.StepType type) {
        Preconditions.checkArgument((type != Step.StepType.STANDARD_STEP ? 1 : 0) != 0, (Object)"This constructor cannot be used for standard steps");
        Preconditions.checkArgument((type != Step.StepType.GENERATOR_STEP ? 1 : 0) != 0, (Object)"This constructor cannot be used for standard steps");
        Objects.requireNonNull(workflow, "Workflow argument cannot be null");
        Objects.requireNonNull(type, "Type argument cannot be null");
        this.workflow = workflow;
        this.number = instanceCount.incrementAndGet();
        this.id = type.getDefaultStepId();
        this.skip = false;
        this.terminalStep = false;
        this.createLogFiles = false;
        this.type = type;
        this.parameters = Collections.emptySet();
        this.parallelizationMode = ParallelizationMode.NOT_NEEDED;
        this.requiredMemory = -1;
        this.requiredProcessors = -1;
        this.dataProductConfiguration = "";
        this.discardOutput = Step.DiscardOutput.SUCCESS;
        this.checker = null;
        switch (type) {
            case CHECKER_STEP: {
                CheckerModule checkerModule = new CheckerModule();
                StepInstances.getInstance().registerStep(this, checkerModule);
                this.moduleName = checkerModule.getName();
                this.version = checkerModule.getVersion().toString();
                this.mode = ExecutionMode.getExecutionMode(checkerModule.getClass());
                this.outputDir = StepOutputDirectory.getInstance().defaultDirectory(workflow, this, checkerModule, false);
                break;
            }
            case DESIGN_STEP: {
                Module checkerModule2 = StepInstances.getInstance().getModule(this.workflow.getCheckerStep());
                DesignModule designModule = new DesignModule(this.workflow.getDesign(), (CheckerModule)checkerModule2);
                StepInstances.getInstance().registerStep(this, designModule);
                this.moduleName = designModule.getName();
                this.version = checkerModule2.getVersion().toString();
                this.mode = ExecutionMode.getExecutionMode(designModule.getClass());
                this.outputDir = StepOutputDirectory.getInstance().defaultDirectory(workflow, this, designModule, false);
                break;
            }
            default: {
                FakeModule fakeModule = new FakeModule();
                StepInstances.getInstance().registerStep(this, fakeModule);
                this.moduleName = type.name();
                this.version = fakeModule.getVersion().toString();
                this.mode = ExecutionMode.NONE;
                this.outputDir = StepOutputDirectory.getInstance().defaultDirectory(workflow, this, fakeModule, false);
            }
        }
        this.stepStateDependencies = new StepStateDependencies(this);
        this.workflow.register(this);
    }

    AbstractStep(AbstractWorkflow workflow, DataFormat format) throws EoulsanException {
        Objects.requireNonNull(workflow, "Workflow argument cannot be null");
        Objects.requireNonNull(format, "Format argument cannot be null");
        Module generatorModule = format.getGenerator();
        StepInstances.getInstance().registerStep(this, generatorModule);
        Objects.requireNonNull(generatorModule, "The generator module is null");
        this.workflow = workflow;
        this.number = instanceCount.incrementAndGet();
        this.id = generatorModule.getName();
        this.skip = false;
        this.terminalStep = false;
        this.createLogFiles = false;
        this.type = Step.StepType.GENERATOR_STEP;
        this.moduleName = generatorModule.getName();
        this.version = generatorModule.getVersion().toString();
        this.mode = ExecutionMode.getExecutionMode(generatorModule.getClass());
        this.parameters = Collections.emptySet();
        this.parallelizationMode = AbstractStep.getParallelizationMode(generatorModule);
        this.requiredMemory = -1;
        this.requiredProcessors = -1;
        this.dataProductConfiguration = "";
        this.discardOutput = Step.DiscardOutput.SUCCESS;
        this.checker = null;
        this.outputDir = StepOutputDirectory.getInstance().defaultDirectory(workflow, this, generatorModule, false);
        this.stepStateDependencies = new StepStateDependencies(this);
        this.workflow.register(this);
    }

    AbstractStep(AbstractWorkflow workflow, String id, String moduleName, String stepVersion, boolean skip, Step.DiscardOutput discardOutput, Set<Parameter> parameters, int requiredMemory, int requiredProcessors, String dataProduct) throws EoulsanException {
        this(workflow, id, moduleName, stepVersion, skip, discardOutput, parameters, requiredMemory, requiredProcessors, dataProduct, null);
    }

    AbstractStep(AbstractWorkflow workflow, String id, String moduleName, String stepVersion, boolean skip, Step.DiscardOutput discardOutput, Set<Parameter> parameters, int requiredMemory, int requiredProcessors, String dataProduct, DataFile outputDirectory) throws EoulsanException {
        Objects.requireNonNull(workflow, "Workflow argument cannot be null");
        Objects.requireNonNull(id, "Step id argument cannot be null");
        Objects.requireNonNull(moduleName, "Step module argument cannot be null");
        Objects.requireNonNull(parameters, "parameters argument cannot be null");
        Objects.requireNonNull(dataProduct, "dataProduct argument cannot be null");
        this.workflow = workflow;
        this.number = instanceCount.incrementAndGet();
        this.id = id;
        this.skip = skip;
        this.moduleName = moduleName;
        this.version = stepVersion;
        this.discardOutput = discardOutput;
        this.requiredMemory = requiredMemory;
        this.requiredProcessors = requiredProcessors;
        this.dataProductConfiguration = dataProduct;
        Module module = StepInstances.getInstance().getModule(this, moduleName, stepVersion);
        this.type = EoulsanAnnotationUtils.isGenerator(module) ? Step.StepType.GENERATOR_STEP : Step.StepType.STANDARD_STEP;
        this.mode = ExecutionMode.getExecutionMode(module.getClass());
        this.parameters = Sets.newLinkedHashSet(parameters);
        this.terminalStep = EoulsanAnnotationUtils.isTerminal(module);
        this.createLogFiles = !EoulsanAnnotationUtils.isNoLog(module);
        this.parallelizationMode = AbstractStep.getParallelizationMode(module);
        this.checker = module.getChecker();
        this.outputDir = outputDirectory != null ? outputDirectory : StepOutputDirectory.getInstance().defaultDirectory(workflow, this, module, discardOutput.isCopyResultsToOutput());
        this.stepStateDependencies = new StepStateDependencies(this);
        this.workflow.register(this);
    }
}

