/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.Subscribe;
import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.Workflow;
import fr.ens.biologie.genomique.eoulsan.core.schedulers.TaskSchedulerFactory;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.EmergencyStopTasks;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ExecutorArguments;
import fr.ens.biologie.genomique.eoulsan.core.workflow.SerializableStopwatch;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepResult;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepStateEvent;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TokenManager;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TokenManagerRegistry;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UIWorkflowEvent;
import fr.ens.biologie.genomique.eoulsan.core.workflow.Workflow2Graphviz;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowContext;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowEventBus;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.io.Eoulsan2DesignWriter;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.process.DockerManager;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractWorkflow
implements Workflow {
    private static final long serialVersionUID = 4865597995432347155L;
    private static final String DESIGN_COPY_FILENAME = "design.txt";
    protected static final String WORKFLOW_COPY_FILENAME = "workflow.xml";
    private static final String WORKFLOW_GRAPHVIZ_FILENAME = "workflow.dot";
    private static final String WORKFLOW_IMAGE_FILENAME = "workflow.png";
    private final DataFile localWorkingDir;
    private final DataFile hadoopWorkingDir;
    private final DataFile outputDir;
    private final DataFile jobDir;
    private final DataFile taskDir;
    private final DataFile dataDir;
    private final DataFile tmpDir;
    private final Design design;
    private final WorkflowContext workflowContext;
    private final Set<String> stepIds = new HashSet<String>();
    private final Map<AbstractStep, Step.StepState> steps = new HashMap<AbstractStep, Step.StepState>();
    private final Multimap<Step.StepState, AbstractStep> states = ArrayListMultimap.create();
    private final SerializableStopwatch stopwatch = new SerializableStopwatch();
    private AbstractStep rootStep;
    private AbstractStep designStep;
    private AbstractStep checkerStep;
    private AbstractStep firstStep;
    private final Set<DataFile> deleteOnExitFiles = new HashSet<DataFile>();
    private volatile boolean shutdownNow;

    DataFile getLocalWorkingDirectory() {
        return this.localWorkingDir;
    }

    DataFile getHadoopWorkingDirectory() {
        return this.hadoopWorkingDir;
    }

    DataFile getOutputDirectory() {
        return this.outputDir;
    }

    DataFile getJobDirectory() {
        return this.jobDir;
    }

    DataFile getTaskDirectory() {
        return this.taskDir;
    }

    DataFile getDataRepositoryDirectory() {
        return this.dataDir;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    @Override
    public Set<Step> getSteps() {
        HashSet<AbstractStep> result = new HashSet<AbstractStep>(this.steps.keySet());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Step getRootStep() {
        return this.rootStep;
    }

    @Override
    public Step getDesignStep() {
        return this.designStep;
    }

    @Override
    public Step getFirstStep() {
        return this.firstStep;
    }

    protected Step getCheckerStep() {
        return this.checkerStep;
    }

    public WorkflowContext getWorkflowContext() {
        return this.workflowContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(AbstractStep step) {
        Objects.requireNonNull(step, "step cannot be null");
        if (step.getWorkflow() != this) {
            throw new IllegalStateException("step cannot be part of more than one workflow");
        }
        if (this.stepIds.contains(step.getId())) {
            throw new IllegalStateException("2 step cannot had the same id: " + step.getId());
        }
        if (step.getType() == Step.StepType.ROOT_STEP) {
            if (this.rootStep != null && step != this.rootStep) {
                throw new IllegalStateException("Cannot add 2 root steps to the workflow");
            }
            this.rootStep = step;
        }
        if (step.getType() == Step.StepType.DESIGN_STEP) {
            if (this.designStep != null && step != this.designStep) {
                throw new IllegalStateException("Cannot add 2 design steps to the workflow");
            }
            this.designStep = step;
        }
        if (step.getType() == Step.StepType.CHECKER_STEP) {
            if (this.checkerStep != null && step != this.checkerStep) {
                throw new IllegalStateException("Cannot add 2 checkers steps to the workflow");
            }
            this.checkerStep = step;
        }
        if (step.getType() == Step.StepType.FIRST_STEP) {
            if (this.firstStep != null && step != this.firstStep) {
                throw new IllegalStateException("Cannot add 2 first steps to the workflow");
            }
            this.firstStep = step;
        }
        AbstractWorkflow abstractWorkflow = this;
        synchronized (abstractWorkflow) {
            this.stepIds.add(step.getId());
            this.steps.put(step, step.getState());
            this.states.put((Object)step.getState(), (Object)step);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void stepStateEvent(StepStateEvent event) {
        if (event == null) {
            return;
        }
        AbstractStep step = event.getStep();
        Step.StepState newState = event.getState();
        if (step.getWorkflow() != this) {
            throw new IllegalStateException("step is not part of the workflow");
        }
        AbstractWorkflow abstractWorkflow = this;
        synchronized (abstractWorkflow) {
            Step.StepState oldState = this.steps.get(step);
            if (oldState == newState) {
                return;
            }
            this.states.remove((Object)oldState, (Object)step);
            this.states.put((Object)newState, (Object)step);
            this.steps.put(step, newState);
        }
    }

    @Override
    public void deleteOnExit(DataFile file) {
        Objects.requireNonNull(file, "file argument is null");
        this.deleteOnExitFiles.add(file);
    }

    private void checkExistingOutputFiles() throws EoulsanException {
        for (AbstractStep step : this.steps.keySet()) {
            if (step.getType() != Step.StepType.STANDARD_STEP || step.isSkip()) continue;
            for (StepOutputPort port : step.getWorkflowOutputPorts()) {
                List<DataFile> files = port.getExistingOutputFiles();
                if (files.isEmpty()) continue;
                throw new EoulsanException("For the step " + step.getId() + " data generated by the port " + port.getName() + " already exists: " + files.get(0));
            }
        }
    }

    private void checkExistingInputFiles() throws EoulsanException {
        for (AbstractStep step : this.steps.keySet()) {
            if (step.getType() != Step.StepType.STANDARD_STEP || step.isSkip()) continue;
            for (StepInputPort port : step.getWorkflowInputPorts()) {
                List<DataFile> files;
                StepOutputPort link = port.getLink();
                if (link.getStep().getType() != Step.StepType.STANDARD_STEP || !link.getStep().isSkip() || !(files = link.getExistingOutputFiles()).isEmpty()) continue;
                throw new EoulsanException("For the step \"" + step.getId() + "\" data needed by the port \"" + port.getName() + "\" not exists (this data is generated by the port \"" + link.getName() + "\" of the step \"" + link.getStep().getId() + "\")");
            }
        }
    }

    private void skipGeneratorsIfNotNeeded() {
        for (AbstractStep step : this.steps.keySet()) {
            if (step.getType() != Step.StepType.GENERATOR_STEP) continue;
            boolean allStepSkipped = true;
            for (StepOutputPort outputPort : step.getWorkflowOutputPorts()) {
                if (outputPort.isAllLinksToSkippedSteps()) continue;
                allStepSkipped = false;
                break;
            }
            if (!allStepSkipped) continue;
            step.setSkipped(true);
        }
    }

    public void execute() throws EoulsanException {
        this.skipGeneratorsIfNotNeeded();
        this.checkExistingOutputFiles();
        this.checkExistingInputFiles();
        this.saveConfigurationFiles();
        TaskSchedulerFactory.initialize();
        TaskSchedulerFactory.getScheduler().start();
        TokenManagerRegistry registry = TokenManagerRegistry.getInstance();
        WorkflowEventBus eventBus = WorkflowEventBus.getInstance();
        for (AbstractStep step : this.steps.keySet()) {
            registry.getTokenManager(step);
            eventBus.postStepStateChange(step, Step.StepState.WAITING);
        }
        Thread shutdownThread = this.createShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        this.stopwatch.start();
        while (!this.getSortedStepsByState(Step.StepState.READY, Step.StepState.WAITING, Step.StepState.PARTIALLY_DONE, Step.StepState.WORKING).isEmpty()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.shutdownNow) {
                EoulsanException e = new EoulsanException("Shutdown of the workflow required by the user (e.g. Ctrl-C)");
                this.emergencyStop(e, e.getMessage());
                break;
            }
            List<AbstractStep> failedSteps = this.getSortedStepsByState(Step.StepState.FAILED);
            if (failedSteps.isEmpty()) continue;
            StepResult firstResult = null;
            for (AbstractStep failedStep : failedSteps) {
                StepResult result = TaskSchedulerFactory.getScheduler().getResult(failedStep);
                EoulsanLogger.getLogger().severe("Fail of the analysis: " + result.getErrorMessage());
                if (firstResult != null) continue;
                firstResult = result;
            }
            Throwable exception = firstResult.getException() != null ? firstResult.getException() : new EoulsanException("Fail of the analysis.");
            EoulsanLogger.logSevere("Cause of the fail of the analysis: " + StringUtils.stackTraceToString((Throwable)exception));
            this.emergencyStop(exception, firstResult.getErrorMessage());
            break;
        }
        EoulsanLogger.logInfo("Remove shutdownThread");
        Runtime.getRuntime().removeShutdownHook(shutdownThread);
        this.removeOutputsToDiscard();
        this.stop();
        this.logEndAnalysis(true);
    }

    private void stop() {
        TokenManagerRegistry registry = TokenManagerRegistry.getInstance();
        for (AbstractStep step : this.steps.keySet()) {
            TokenManager tokenManager = registry.getTokenManager(step);
            if (!tokenManager.isStarted()) continue;
            tokenManager.stop();
        }
        TaskSchedulerFactory.getScheduler().stop();
        for (DataFile file : this.deleteOnExitFiles) {
            try {
                if (!file.exists()) continue;
                file.delete(true);
            }
            catch (IOException e) {
                EoulsanLogger.logWarning("Cannot remove file " + file + " on exit: " + file);
            }
        }
        try {
            DockerManager.closeConnections();
        }
        catch (IOException e) {
            EoulsanLogger.logWarning("Error while closing Docker connection");
        }
    }

    void emergencyStop(Throwable exception, String errorMessage) {
        WorkflowEventBus eventBus = WorkflowEventBus.getInstance();
        for (AbstractStep abstractStep : this.getSortedStepsByState(Step.StepState.PARTIALLY_DONE, Step.StepState.WORKING)) {
            eventBus.postStepStateChange(abstractStep, Step.StepState.ABORTED);
        }
        this.stop();
        TokenManagerRegistry registry = TokenManagerRegistry.getInstance();
        for (AbstractStep step : this.getSortedStepsByState(Step.StepState.FAILED)) {
            registry.getTokenManager(step).removeAllOutputs();
        }
        for (AbstractStep step : this.getSortedStepsByState(Step.StepState.ABORTED)) {
            registry.getTokenManager(step).removeAllOutputs();
        }
        EmergencyStopTasks.getInstance().stop();
        try {
            DockerManager.closeConnections();
        }
        catch (IOException iOException) {
            EoulsanLogger.logWarning("Error while closing Docker connection");
        }
        this.logEndAnalysis(false);
        Common.errorHalt(exception, errorMessage);
    }

    private void removeOutputsToDiscard() {
        TokenManagerRegistry registry = TokenManagerRegistry.getInstance();
        for (AbstractStep step : this.steps.keySet()) {
            TokenManager tokenManager = registry.getTokenManager(step);
            tokenManager.removeOutputsToDiscard();
        }
    }

    public Thread createShutdownHookThread() {
        AbstractWorkflow workflow = this;
        Thread mainThread = Thread.currentThread();
        return new Thread(() -> {
            workflow.shutdownNow = true;
            try {
                mainThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }

    protected void saveConfigurationFiles() throws EoulsanException {
        try {
            DataFile jobDir = this.getWorkflowContext().getJobDirectory();
            if (!jobDir.exists()) {
                jobDir.mkdirs();
            }
            Eoulsan2DesignWriter designWriter = new Eoulsan2DesignWriter(new DataFile(jobDir, DESIGN_COPY_FILENAME).create());
            designWriter.write(this.getDesign());
            Workflow2Graphviz graphviz = new Workflow2Graphviz(this, new DataFile(jobDir, WORKFLOW_GRAPHVIZ_FILENAME), new DataFile(jobDir, WORKFLOW_IMAGE_FILENAME));
            if (!this.workflowContext.getSettings().isSaveWorkflowImage() || !graphviz.saveImageFile()) {
                graphviz.saveDotFile();
            }
        }
        catch (IOException e) {
            throw new EoulsanException("Error while writing design file or Graphiviz workflow file: " + e.getMessage(), e);
        }
    }

    private List<AbstractStep> getSortedStepsByState(Step.StepState ... states) {
        Objects.requireNonNull(states, "states argument is null");
        ArrayList<AbstractStep> result = new ArrayList<AbstractStep>();
        for (Step.StepState state : states) {
            result.addAll(this.getSortedStepsByState(state));
        }
        AbstractWorkflow.sortListSteps(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AbstractStep> getSortedStepsByState(Step.StepState state) {
        ArrayList result;
        Objects.requireNonNull(state, "state argument is null");
        AbstractWorkflow abstractWorkflow = this;
        synchronized (abstractWorkflow) {
            result = Lists.newArrayList((Iterable)this.states.get((Object)state));
        }
        AbstractWorkflow.sortListSteps(result);
        return result;
    }

    private static void sortListSteps(List<AbstractStep> list) {
        if (list == null) {
            return;
        }
        list.sort(Comparator.comparingInt(a -> a.getType().getPriority()).thenComparingInt(AbstractStep::getNumber));
    }

    private static DataFile newDataFile(String path) {
        if (path == null) {
            return null;
        }
        return new DataFile(URI.create(path));
    }

    public void checkDirectories() throws EoulsanException {
        Objects.requireNonNull(this.jobDir, "the job directory is null");
        Objects.requireNonNull(this.taskDir, "the task directory is null");
        Objects.requireNonNull(this.outputDir, "the output directory is null");
        Objects.requireNonNull(this.localWorkingDir, "the local working directory is null");
        Settings settings = EoulsanRuntime.getSettings();
        ArrayList dirsToCheck = Lists.newArrayList((Object[])new DataFile[]{this.jobDir, this.outputDir, this.localWorkingDir, this.hadoopWorkingDir, this.taskDir});
        if (!settings.isUserDefinedTempDirectory()) {
            Objects.requireNonNull(this.tmpDir, "The temporary directory is null");
            settings.setTempDirectory(this.tmpDir.toFile().toString());
            dirsToCheck.add(this.tmpDir);
        }
        try {
            for (DataFile dir : dirsToCheck) {
                if (dir == null) continue;
                AbstractWorkflow.createDirectory(dir);
            }
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
        this.checkTemporaryDirectory();
    }

    public void createEoulsanDataDirectoryIfRequired() throws EoulsanException {
        try {
            Settings settings = EoulsanRuntime.getSettings();
            if (settings.getGenomeMapperIndexStoragePath() == null) {
                DataFile mapperIndexDir = new DataFile(this.dataDir, "mapperindexes");
                settings.setGenomeMapperIndexStoragePath(mapperIndexDir.getSource());
                AbstractWorkflow.createDirectory(mapperIndexDir);
            }
            if (settings.getGenomeDescStoragePath() == null) {
                DataFile genomeDescriptionDir = new DataFile(this.dataDir, "genomedescriptions");
                settings.setGenomeDescStoragePath(genomeDescriptionDir.getSource());
                AbstractWorkflow.createDirectory(genomeDescriptionDir);
            }
            if (settings.getDockerSingularityStoragePath() == null) {
                DataFile singularityDir = new DataFile(this.dataDir, "singularity");
                settings.setDockerSingularityStoragePath(singularityDir.getSource());
            }
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
    }

    private static void createDirectory(DataFile directory) throws IOException {
        if (directory.exists() && !directory.getMetaData().isDir()) {
            throw new IOException("the directory is not a directory: " + directory);
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    private void checkTemporaryDirectory() throws EoulsanException {
        File tempDir = EoulsanRuntime.getSettings().getTempDirectoryFile();
        if (tempDir == null) {
            throw new EoulsanException("Temporary directory is null");
        }
        if ("".equals(tempDir.getAbsolutePath())) {
            throw new EoulsanException("Temporary directory is null");
        }
        if (!tempDir.exists()) {
            throw new EoulsanException("Temporary directory does not exists: " + tempDir);
        }
        if (!tempDir.isDirectory()) {
            throw new EoulsanException("Temporary directory is not a directory: " + tempDir);
        }
        if (!tempDir.canRead()) {
            throw new EoulsanException("Temporary directory cannot be read: " + tempDir);
        }
        if (!tempDir.canWrite()) {
            throw new EoulsanException("Temporary directory cannot be written: " + tempDir);
        }
        if (!tempDir.canExecute()) {
            throw new EoulsanException("Temporary directory is not executable: " + tempDir);
        }
    }

    private void logEndAnalysis(boolean success) {
        this.stopwatch.stop();
        String successString = success ? "Successful" : "Unsuccessful";
        EoulsanLogger.getLogger().info(successString + " end of the analysis in " + StringUtils.toTimeHumanReadable((long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS)) + " s.");
        WorkflowEventBus.getInstance().postUIEvent(new UIWorkflowEvent(success, "(Job done in " + StringUtils.toTimeHumanReadable((long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS)) + " s.)"));
        String mailSubject = "[Eoulsan] " + successString + " end of your job " + this.workflowContext.getJobId() + " on " + this.workflowContext.getJobHost();
        String mailMessage = "THIS IS AN AUTOMATED MESSAGE.\n\n" + successString + " end of your job " + this.workflowContext.getJobId() + " on " + this.workflowContext.getJobHost() + ".\nJob finished at " + new Date(System.currentTimeMillis()) + " in " + StringUtils.toTimeHumanReadable((long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS)) + " s.\n\nOutput files and logs can be found in the following location:\n" + this.workflowContext.getOutputDirectory() + "\n\nThe Eoulsanteam.";
        Common.sendMail(mailSubject, mailMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        AbstractWorkflow abstractWorkflow = this;
        synchronized (abstractWorkflow) {
            s.defaultWriteObject();
        }
    }

    protected AbstractWorkflow(ExecutorArguments executionArguments, Design design) throws EoulsanException {
        Objects.requireNonNull(executionArguments, "Argument cannot be null");
        Objects.requireNonNull(design, "Design argument cannot be null");
        this.design = design;
        this.jobDir = AbstractWorkflow.newDataFile(executionArguments.getJobPathname());
        this.taskDir = AbstractWorkflow.newDataFile(executionArguments.getTaskPathname());
        this.tmpDir = AbstractWorkflow.newDataFile(executionArguments.getTemporaryPathname());
        this.localWorkingDir = AbstractWorkflow.newDataFile(executionArguments.getLocalWorkingPathname());
        this.hadoopWorkingDir = AbstractWorkflow.newDataFile(executionArguments.getHadoopWorkingPathname());
        this.outputDir = AbstractWorkflow.newDataFile(executionArguments.getOutputPathname());
        this.dataDir = AbstractWorkflow.newDataFile(executionArguments.getDataPathname());
        this.workflowContext = new WorkflowContext(executionArguments, this);
        WorkflowEventBus.getInstance().register(this);
    }
}

