/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Strings;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.CommandWorkflowParser;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CommandWorkflowModel
implements Serializable {
    private static final long serialVersionUID = -5182569666862886788L;
    private String name = "";
    private String description = "";
    private String author = "";
    private final List<String> stepIdList = new ArrayList<String>();
    private final Map<String, String> moduleNames = new HashMap<String, String>();
    private final Map<String, String> stepVersions = new HashMap<String, String>();
    private final Map<String, Map<String, StepPort>> stepInputs = new HashMap<String, Map<String, StepPort>>();
    private final Map<String, Set<Parameter>> stepParameters = new HashMap<String, Set<Parameter>>();
    private final Map<String, Boolean> stepSkipped = new HashMap<String, Boolean>();
    private final Map<String, Step.DiscardOutput> stepDiscardOutput = new HashMap<String, Step.DiscardOutput>();
    private final Map<String, Integer> stepRequiredMemory = new HashMap<String, Integer>();
    private final Map<String, Integer> stepRequiredProcessors = new HashMap<String, Integer>();
    private final Map<String, String> stepDataProduct = new HashMap<String, String>();
    private final Set<Parameter> globalParameters = new HashSet<Parameter>();

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    void setDescription(String description) {
        if (description != null) {
            this.description = description;
        }
    }

    void setAuthor(String author) {
        if (author != null) {
            this.author = author;
        }
    }

    void setGlobalParameters(Set<Parameter> parameters) {
        this.globalParameters.addAll(parameters);
    }

    public Set<Parameter> getGlobalParameters() {
        return this.globalParameters;
    }

    void addStep(String stepId, String module, String version, Map<String, CommandWorkflowParser.StepOutputPort> inputs, Set<Parameter> parameters, boolean skipStep, Step.DiscardOutput discardOutput, int requiredMemory, int requiredProcs, String dataProduct) throws EoulsanException {
        if (module == null) {
            throw new EoulsanException("The module of the step is null.");
        }
        String moduleLower = module.toLowerCase().trim();
        if ("".equals(moduleLower)) {
            throw new EoulsanException("The name of the step is empty.");
        }
        String stepIdLower = stepId == null || "".equals(stepId.trim()) ? moduleLower : stepId.toLowerCase().trim();
        if ("".equals(stepIdLower)) {
            throw new EoulsanException("The id of the step is empty.");
        }
        if (!FileNaming.isStepIdValid(stepIdLower)) {
            throw new EoulsanException("The id of the step is not valid (only ascii letters and digits are allowed): " + stepIdLower);
        }
        String stepVersion = Strings.nullToEmpty((String)version).trim();
        if (this.stepParameters.containsKey(stepIdLower) || Step.StepType.getAllDefaultStepId().contains(stepIdLower)) {
            throw new EoulsanException("The step id already exists: " + stepIdLower);
        }
        if (parameters == null) {
            throw new EoulsanException("The parameters are null.");
        }
        if (inputs == null) {
            throw new EoulsanException("The inputs are null.");
        }
        HashMap<String, StepPort> inputsMap = new HashMap<String, StepPort>();
        for (Map.Entry<String, CommandWorkflowParser.StepOutputPort> e : inputs.entrySet()) {
            String toPortName = e.getKey();
            String fromStep = e.getValue().stepId;
            String fromPortName = e.getValue().outputPortName;
            if (toPortName == null) {
                throw new EoulsanException("The input port name is null for input for step \"" + stepId);
            }
            if (fromStep == null) {
                throw new EoulsanException("The step name that generate \"" + toPortName + "\" for step \"" + stepId + "\" is null");
            }
            if (fromPortName == null) {
                throw new EoulsanException("The output port name is null for input " + toPortName + " for step \"" + stepId);
            }
            toPortName = toPortName.trim().toLowerCase();
            fromStep = fromStep.trim().toLowerCase();
            fromPortName = fromPortName.trim().toLowerCase();
            if (!Step.StepType.DESIGN_STEP.getDefaultStepId().equals(fromStep) && !this.moduleNames.containsKey(fromStep)) {
                throw new EoulsanException("The step that generate \"" + toPortName + "\" for step \"" + stepId + "\" has not been yet declared");
            }
            inputsMap.put(toPortName, new StepPort(fromStep, fromPortName));
        }
        if (dataProduct == null) {
            throw new EoulsanException("The data product value is null for input for step \"" + stepId);
        }
        this.stepIdList.add(stepIdLower);
        this.moduleNames.put(stepIdLower, moduleLower);
        this.stepVersions.put(stepIdLower, stepVersion);
        this.stepInputs.put(stepIdLower, inputsMap);
        this.stepParameters.put(stepIdLower, parameters);
        this.stepSkipped.put(stepIdLower, skipStep);
        this.stepDiscardOutput.put(stepIdLower, discardOutput);
        this.stepRequiredMemory.put(stepIdLower, requiredMemory);
        this.stepRequiredProcessors.put(stepIdLower, requiredProcs);
        this.stepDataProduct.put(stepIdLower, dataProduct);
    }

    public List<String> getStepIds() {
        return this.stepIdList;
    }

    public String getModuleName(String stepId) {
        return this.moduleNames.get(stepId);
    }

    public String getStepVersion(String stepId) {
        return this.stepVersions.get(stepId);
    }

    public Map<String, StepPort> getStepInputs(String stepId) {
        Map<String, StepPort> result = this.stepInputs.get(stepId);
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    public Set<Parameter> getStepParameters(String stepId) {
        Set<Parameter> result = this.stepParameters.get(stepId);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public boolean isStepSkipped(String stepId) {
        return this.stepSkipped.get(stepId);
    }

    public Step.DiscardOutput getStepDiscardOutput(String stepId) {
        return this.stepDiscardOutput.get(stepId);
    }

    public int getStepRequiredMemory(String stepId) {
        return this.stepRequiredMemory.get(stepId);
    }

    public int getStepRequiredProcessors(String stepId) {
        return this.stepRequiredProcessors.get(stepId);
    }

    public String getStepDataProduct(String stepId) {
        return this.stepDataProduct.get(stepId);
    }

    private void addGlobalParameter(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        String keyTrimmed = key.trim();
        String valueTrimmed = value.trim();
        if ("".equals(keyTrimmed)) {
            return;
        }
        Parameter p = new Parameter(keyTrimmed, valueTrimmed);
        this.globalParameters.add(p);
    }

    public String toXML() throws EoulsanException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("analysis");
            doc.appendChild(rootElement);
            this.addElement(doc, rootElement, "formatversion", "1.0");
            this.addElement(doc, rootElement, "name", this.getName());
            this.addElement(doc, rootElement, "description", this.getDescription());
            this.addElement(doc, rootElement, "author", this.getAuthor());
            Element stepsElement = doc.createElement("steps");
            rootElement.appendChild(stepsElement);
            for (String stepId : this.stepIdList) {
                this.addStepElement(doc, stepsElement, stepId);
            }
            this.addParametersElement(doc, rootElement, "globals", this.globalParameters);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            return writer.getBuffer().toString();
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new EoulsanRuntimeException(e);
        }
    }

    private void addElement(Document document, Element root, String tagName, String tagValue) {
        if (document == null || root == null || tagName == null || "".equals(tagName.trim()) || tagValue == null) {
            return;
        }
        if ("".equals(tagValue.trim()) && !"value".equals(tagName)) {
            return;
        }
        Element e = document.createElement(tagName);
        e.appendChild(document.createTextNode(tagValue));
        root.appendChild(e);
    }

    private void addParametersElement(Document document, Element root, String elementName, Set<Parameter> parameters) {
        if (document == null || root == null || parameters == null || elementName == null || "".equals(elementName.trim())) {
            return;
        }
        Element parametersElement = document.createElement(elementName);
        root.appendChild(parametersElement);
        for (Parameter p : parameters) {
            Element parameterElement = document.createElement("parameter");
            parametersElement.appendChild(parameterElement);
            this.addElement(document, parameterElement, "name", p.getName());
            this.addElement(document, parameterElement, "value", p.getValue());
        }
    }

    private void addStepElement(Document document, Element root, String stepId) {
        if (document == null || root == null || stepId == null || "".equals(stepId.trim())) {
            return;
        }
        Element stepElement = document.createElement("step");
        root.appendChild(stepElement);
        Attr idAttr = document.createAttribute("id");
        idAttr.setValue(stepId);
        stepElement.setAttributeNode(idAttr);
        Attr discardAttr = document.createAttribute("discardoutput");
        discardAttr.setValue("" + (Object)((Object)this.stepDiscardOutput.get(stepId)));
        stepElement.setAttributeNode(discardAttr);
        Attr skipAttr = document.createAttribute("skip");
        skipAttr.setValue("" + this.stepSkipped.get(stepId));
        stepElement.setAttributeNode(skipAttr);
        if (this.stepRequiredMemory.get(stepId) > 0) {
            Attr requiredMemoryAttr = document.createAttribute("requiredmemory");
            requiredMemoryAttr.setValue(this.stepRequiredMemory.get(stepId) + "MB");
            stepElement.setAttributeNode(requiredMemoryAttr);
        }
        if (this.stepRequiredProcessors.get(stepId) > 0) {
            Attr requiredProcessorsAttr = document.createAttribute("requiredprocs");
            requiredProcessorsAttr.setValue("" + this.stepRequiredProcessors.get(stepId));
            stepElement.setAttributeNode(requiredProcessorsAttr);
        }
        if (this.stepDataProduct != null && !"".equals(this.stepDataProduct.get(stepId).trim())) {
            Attr dataProductAttr = document.createAttribute("dataproduct");
            dataProductAttr.setValue(this.stepDataProduct.get(stepId));
            stepElement.setAttributeNode(dataProductAttr);
        }
        this.addElement(document, stepElement, "name", this.moduleNames.get(stepId));
        this.addElement(document, stepElement, "version", this.stepVersions.get(stepId));
        Element inputsElement = document.createElement("inputs");
        stepElement.appendChild(inputsElement);
        for (Map.Entry<String, StepPort> e : this.stepInputs.get(stepId).entrySet()) {
            Element inputElement = document.createElement("input");
            inputsElement.appendChild(inputElement);
            this.addElement(document, inputElement, "port", e.getKey());
            this.addElement(document, inputElement, "fromstep", e.getValue().stepId);
            this.addElement(document, inputElement, "fromport", e.getValue().portName);
        }
        this.addParametersElement(document, stepElement, "parameters", this.stepParameters.get(stepId));
    }

    public CommandWorkflowModel() {
        this(true);
    }

    public CommandWorkflowModel(boolean addSettingsValues) {
        if (addSettingsValues) {
            Settings settings = EoulsanRuntime.getRuntime().getSettings();
            for (String settingName : settings.getSettingsNames()) {
                this.addGlobalParameter(settingName, settings.getSetting(settingName));
            }
        }
    }

    static final class StepPort
    implements Serializable {
        private static final long serialVersionUID = -1282360626885971051L;
        final String stepId;
        final String portName;

        private StepPort(String stepId, String portName) {
            this.stepId = stepId;
            this.portName = portName;
        }
    }
}

