/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.CommandWorkflowModel;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ExecutorArguments;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.util.ProcessUtils;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CommandWorkflowParser {
    public static final String VERSION_CONSTANT_NAME = Globals.APP_NAME_LOWER_CASE + ".version";
    public static final String BUILD_NUMBER_CONSTANT_NAME = Globals.APP_NAME_LOWER_CASE + ".build.number";
    public static final String BUILD_DATE_CONSTANT_NAME = Globals.APP_NAME_LOWER_CASE + ".build.date";
    public static final String AVAILABLE_PROCESSORS_CONSTANT_NAME = Globals.APP_NAME_LOWER_CASE + "available.processors";
    public static final String DESIGN_FILE_PATH_CONSTANT_NAME = "design.file.path";
    public static final String WORKFLOW_FILE_PATH_CONSTANT_NAME = "workflow.file.path";
    public static final String OUTPUT_PATH_CONSTANT_NAME = "output.path";
    public static final String JOB_ID_CONSTANT_NAME = "job.id";
    public static final String JOB_UUID_CONSTANT_NAME = "job.uuid";
    public static final String JOB_PATH_CONSTANT_NAME = "job.path";
    static final String FORMAT_VERSION = "1.0";
    static final String WORKFLOWNAME_TAG_NAME = "name";
    static final String PARAMETERNAME_TAG_NAME = "name";
    static final String PARAMETERVALUE_TAG_NAME = "value";
    static final String PARAMETER_TAG_NAME = "parameter";
    static final String FROMPORT_TAG_NAME = "fromport";
    static final String FROMSTEP_TAG_NAME = "fromstep";
    static final String PORT_TAG_NAME = "port";
    static final String INPUT_TAG_NAME = "input";
    static final String INPUTS_TAG_NAME = "inputs";
    static final String GLOBALS_TAG_NAME = "globals";
    static final String PARAMETERS_TAG_NAME = "parameters";
    static final String STEPNAME_TAG_NAME = "stepname";
    static final String MODULE_TAG_NAME = "module";
    static final String DISCARDOUTPUT_ATTR_NAME_STEP_TAG = "discardoutput";
    static final String SKIP_ATTR_NAME_STEP_TAG = "skip";
    static final String REQUIRED_MEM_ATTR_NAME_STEP_TAG = "requiredmemory";
    static final String REQUIRED_CPU_ATTR_NAME_STEP_TAG = "requiredprocs";
    static final String DATAPRODUCT_ATTR_NAME_STEP_TAG = "dataproduct";
    static final String ID_ATTR_NAME_STEP_TAG = "id";
    static final String VERSION_TAG = "version";
    static final String STEP_TAG_NAME = "step";
    static final String STEPS_TAG_NAME = "steps";
    static final String CONSTANTS_TAG_NAME = "constants";
    static final String AUTHOR_TAG_NAME = "author";
    static final String DESCRIPTION_TAG_NAME = "description";
    static final String NAME_TAG_NAME = "name";
    static final String FORMATVERSION_TAG_NAME = "formatversion";
    static final String ROOT_TAG_NAME = "analysis";
    private final InputStream is;
    private final Map<String, String> constants = CommandWorkflowParser.initConstants();

    public CommandWorkflowModel parse() throws EoulsanException {
        Document doc;
        EoulsanLogger.getLogger().info("Start parsing the workflow workflow file");
        CommandWorkflowModel result = new CommandWorkflowModel();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(this.is);
            doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new EoulsanException("Error while parsing workflow file: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new EoulsanException("Error while reading workflow file. " + e.getMessage(), e);
        }
        NodeList nAnalysisList = doc.getElementsByTagName(ROOT_TAG_NAME);
        for (int i = 0; i < nAnalysisList.getLength(); ++i) {
            Node nNode = nAnalysisList.item(i);
            if (nNode.getNodeType() != 1) continue;
            Element eElement = (Element)nNode;
            CommandWorkflowParser.checkAllowedChildTags(eElement, FORMATVERSION_TAG_NAME, "name", DESCRIPTION_TAG_NAME, AUTHOR_TAG_NAME, CONSTANTS_TAG_NAME, STEPS_TAG_NAME, GLOBALS_TAG_NAME);
            String formatVersion = CommandWorkflowParser.getTagValue(FORMATVERSION_TAG_NAME, eElement);
            if (formatVersion == null || !FORMAT_VERSION.equals(formatVersion)) {
                throw new EoulsanException("Invalid version of the format of the workflow file.");
            }
            String name = CommandWorkflowParser.getTagValue("name", eElement);
            result.setName(name);
            String description = CommandWorkflowParser.getTagValue(DESCRIPTION_TAG_NAME, eElement);
            result.setDescription(description);
            String author = CommandWorkflowParser.getTagValue(AUTHOR_TAG_NAME, eElement);
            result.setAuthor(author);
            this.addConstants(this.parseParameters(eElement, CONSTANTS_TAG_NAME, null, false));
            NodeList nStepsList = eElement.getElementsByTagName(STEPS_TAG_NAME);
            for (int j = 0; j < nStepsList.getLength(); ++j) {
                Node nodeSteps = nStepsList.item(j);
                if (nodeSteps.getNodeType() != 1) continue;
                Element stepsElement = (Element)nodeSteps;
                CommandWorkflowParser.checkAllowedChildTags(stepsElement, STEP_TAG_NAME);
                NodeList nStepList = stepsElement.getElementsByTagName(STEP_TAG_NAME);
                for (int k = 0; k < nStepList.getLength(); ++k) {
                    Node nStepNode = nStepList.item(k);
                    if (nStepNode.getNodeType() != 1) continue;
                    Element eStepElement = (Element)nStepNode;
                    CommandWorkflowParser.checkAllowedAttributes(eStepElement, ID_ATTR_NAME_STEP_TAG, SKIP_ATTR_NAME_STEP_TAG, REQUIRED_MEM_ATTR_NAME_STEP_TAG, REQUIRED_CPU_ATTR_NAME_STEP_TAG, REQUIRED_CPU_ATTR_NAME_STEP_TAG, DISCARDOUTPUT_ATTR_NAME_STEP_TAG, DATAPRODUCT_ATTR_NAME_STEP_TAG);
                    CommandWorkflowParser.checkAllowedChildTags(eStepElement, MODULE_TAG_NAME, STEPNAME_TAG_NAME, "name", VERSION_TAG, INPUTS_TAG_NAME, PARAMETERS_TAG_NAME);
                    String stepId = this.getAttribute(eStepElement, ID_ATTR_NAME_STEP_TAG).trim().toLowerCase();
                    boolean skip = Boolean.parseBoolean(this.getAttribute(eStepElement, SKIP_ATTR_NAME_STEP_TAG).trim().toLowerCase());
                    int requiredMemory = CommandWorkflowParser.parseMemory(this.getAttribute(eStepElement, REQUIRED_MEM_ATTR_NAME_STEP_TAG));
                    int requiredProcs = CommandWorkflowParser.parseProcessors(this.getAttribute(eStepElement, REQUIRED_CPU_ATTR_NAME_STEP_TAG));
                    Step.DiscardOutput discardOutput = Step.DiscardOutput.parse(this.getAttribute(eStepElement, DISCARDOUTPUT_ATTR_NAME_STEP_TAG));
                    String dataProduct = this.getAttribute(eStepElement, DATAPRODUCT_ATTR_NAME_STEP_TAG).trim();
                    String module = CommandWorkflowParser.getTagValue(MODULE_TAG_NAME, eStepElement);
                    if (module == null) {
                        module = CommandWorkflowParser.getTagValue(STEPNAME_TAG_NAME, eStepElement);
                    }
                    if (module == null) {
                        module = CommandWorkflowParser.getTagValue("name", eStepElement);
                    }
                    if (module == null) {
                        throw new EoulsanException("Module name not found in workflow file.");
                    }
                    String version = CommandWorkflowParser.getTagValue(VERSION_TAG, eStepElement);
                    Map<String, StepOutputPort> inputs = this.parseInputs(eStepElement, "".equals(stepId) ? module : stepId);
                    Set<Parameter> parameters = this.parseParameters(eStepElement, PARAMETERS_TAG_NAME, module, true);
                    EoulsanLogger.getLogger().info("In workflow file found " + module + " step (parameters: " + parameters + ").");
                    result.addStep(stepId, module, version, inputs, parameters, skip, discardOutput, requiredMemory, requiredProcs, dataProduct);
                }
            }
            result.setGlobalParameters(this.parseParameters(eElement, GLOBALS_TAG_NAME, null, true));
        }
        EoulsanLogger.getLogger().info("End of parsing of workflow file");
        EoulsanLogger.getLogger().info("Found " + result.getStepIds().size() + " step(s) in workflow file");
        return result;
    }

    private Map<String, StepOutputPort> parseInputs(Element root, String stepId) throws EoulsanException {
        HashMap<String, StepOutputPort> result = new HashMap<String, StepOutputPort>();
        NodeList nList = root.getElementsByTagName(INPUTS_TAG_NAME);
        for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            CommandWorkflowParser.checkAllowedChildTags(element, INPUT_TAG_NAME);
            NodeList nParameterList = element.getElementsByTagName(INPUT_TAG_NAME);
            for (int j = 0; j < nParameterList.getLength(); ++j) {
                Node nParameterNode = nParameterList.item(j);
                if (nParameterNode.getNodeType() != 1) continue;
                Element inputElement = (Element)nParameterNode;
                CommandWorkflowParser.checkAllowedChildTags(inputElement, PORT_TAG_NAME, FROMSTEP_TAG_NAME, FROMPORT_TAG_NAME);
                String portName = CommandWorkflowParser.getTagValue(PORT_TAG_NAME, inputElement);
                if (portName == null) {
                    throw new EoulsanException("the \"toInput\" attribute not exists in an input section of step \"" + stepId + "\" in workflow file.");
                }
                if (portName.isEmpty()) {
                    throw new EoulsanException("the \"toInput\" attribute is empty in an input section of step \"" + stepId + "\" in workflow file.");
                }
                if (result.containsKey(portName)) {
                    throw new EoulsanException("an input for " + portName + " port has been already defined in the inputs section of step \"" + stepId + "\" in workflow file.");
                }
                StepOutputPort input = new StepOutputPort(CommandWorkflowParser.getTagValue(FROMSTEP_TAG_NAME, inputElement), CommandWorkflowParser.getTagValue(FROMPORT_TAG_NAME, inputElement));
                if (input.stepId == null) {
                    throw new EoulsanException("the \"fromStep\" attribute has not been defined for " + portName + " input in section of step \"" + stepId + "\" in workflow file.");
                }
                if (input.stepId.isEmpty()) {
                    throw new EoulsanException("the \"fromStep\" attribute is empty for " + portName + " input in section of step \"" + stepId + "\" in workflow file.");
                }
                if (input.outputPortName == null) {
                    throw new EoulsanException("the \"fromPort\" attribute has not been defined for " + portName + " input in section of step \"" + stepId + "\" in workflow file.");
                }
                if (input.outputPortName.isEmpty()) {
                    throw new EoulsanException("the \"fromPort\" attribute is empty for " + portName + " input in section of step \"" + stepId + "\" in workflow file.");
                }
                result.put(portName, input);
            }
        }
        return result;
    }

    private Set<Parameter> parseParameters(Element root, String elementName, String stepName, boolean evaluateValues) throws EoulsanException {
        LinkedHashSet<Parameter> result = new LinkedHashSet<Parameter>();
        HashSet<String> parameterNames = new HashSet<String>();
        NodeList nList = root.getElementsByTagName(elementName);
        for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            CommandWorkflowParser.checkAllowedChildTags(element, PARAMETER_TAG_NAME);
            NodeList nParameterList = element.getElementsByTagName(PARAMETER_TAG_NAME);
            for (int j = 0; j < nParameterList.getLength(); ++j) {
                Node nParameterNode = nParameterList.item(j);
                if (nParameterNode.getNodeType() != 1) continue;
                Element eParameterElement = (Element)nParameterNode;
                CommandWorkflowParser.checkAllowedChildTags(eParameterElement, "name", PARAMETERVALUE_TAG_NAME);
                String paramName = CommandWorkflowParser.getTagValue("name", eParameterElement);
                String paramValue = CommandWorkflowParser.getTagValue(PARAMETERVALUE_TAG_NAME, eParameterElement);
                if (paramName == null) {
                    throw new EoulsanException("<name> Tag not found in parameter section of " + (String)(stepName == null ? "global parameters" : stepName + " step") + " in workflow file.");
                }
                if (paramValue == null) {
                    throw new EoulsanException("<value> Tag not found in parameter section of " + (String)(stepName == null ? "global parameters" : stepName + " step") + " in workflow file.");
                }
                if (parameterNames.contains(paramName)) {
                    throw new EoulsanException("The parameter \"" + paramName + "\" has been already defined for " + (String)(stepName == null ? "global parameters" : stepName + " step") + " in workflow file.");
                }
                parameterNames.add(paramName);
                result.add(new Parameter(paramName, evaluateValues ? this.evaluateExpressions(paramValue, true) : paramValue));
            }
        }
        return result;
    }

    private static String getTagValue(String tag, Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !tag.equals(n.getNodeName())) continue;
            return n.getTextContent();
        }
        return null;
    }

    private static void checkAllowedAttributes(Element element, String ... attributeNames) throws EoulsanException {
        List<String> attributeList = Arrays.asList(attributeNames);
        NamedNodeMap nnm = element.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            String attributeName;
            Node n = nnm.item(i);
            if (n.getNodeType() != 2 || attributeList.contains(attributeName = n.getNodeName())) continue;
            throw new EoulsanException("the \"" + element.getNodeName() + "\" tag contains an unknown attribute: " + attributeName + ".");
        }
    }

    private static void checkAllowedChildTags(Element element, String ... tagNames) throws EoulsanException {
        List<String> tagList = Arrays.asList(tagNames);
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String childTagName;
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || tagList.contains(childTagName = n.getNodeName())) continue;
            throw new EoulsanException("the \"" + element.getNodeName() + "\" tag contains an unknown tag: " + childTagName + ".");
        }
    }

    private void addConstants(Set<Parameter> parameters) throws EoulsanException {
        if (parameters == null) {
            return;
        }
        for (Parameter p : parameters) {
            if ("".equals(p.getName())) continue;
            this.addConstant(p.getName(), p.getValue(), true);
        }
    }

    public void addConstants(ExecutorArguments arguments) throws EoulsanException {
        if (arguments == null) {
            return;
        }
        this.addConstant(DESIGN_FILE_PATH_CONSTANT_NAME, arguments.getDesignPathname());
        this.addConstant(WORKFLOW_FILE_PATH_CONSTANT_NAME, arguments.getWorkflowPathname());
        this.addConstant(OUTPUT_PATH_CONSTANT_NAME, arguments.getOutputPathname());
        this.addConstant(JOB_ID_CONSTANT_NAME, arguments.getJobId());
        this.addConstant(JOB_UUID_CONSTANT_NAME, arguments.getJobUUID());
        this.addConstant(JOB_PATH_CONSTANT_NAME, arguments.getJobPathname());
    }

    public void addConstant(String constantName, String constantValue) throws EoulsanException {
        this.addConstant(constantName, constantValue, false);
    }

    public void addConstant(String constantName, String constantValue, boolean evaluateValue) throws EoulsanException {
        if (constantName == null || constantValue == null) {
            return;
        }
        if (evaluateValue) {
            this.constants.put(constantName.trim(), this.evaluateExpressions(constantValue, true));
        } else {
            this.constants.put(constantName.trim(), constantValue);
        }
    }

    private static Map<String, String> initConstants() {
        HashMap<String, String> constants = new HashMap<String, String>();
        constants.put(VERSION_CONSTANT_NAME, Globals.APP_VERSION_STRING);
        constants.put(BUILD_NUMBER_CONSTANT_NAME, Globals.APP_BUILD_NUMBER);
        constants.put(BUILD_DATE_CONSTANT_NAME, Globals.APP_BUILD_DATE);
        constants.put(AVAILABLE_PROCESSORS_CONSTANT_NAME, "" + Runtime.getRuntime().availableProcessors());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            constants.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : System.getenv().entrySet()) {
            constants.put((String)entry.getKey(), (String)entry.getValue());
        }
        return constants;
    }

    private String evaluateExpressions(String s, boolean allowExec) throws EoulsanException {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c1;
            int c0 = s.codePointAt(i);
            if (c0 == 36 && i + 1 < len && (c1 = s.codePointAt(i + 1)) == 123) {
                String expr = this.subStr(s, i + 2, 125);
                String trimmedExpr = expr.trim();
                if (this.constants.containsKey(trimmedExpr)) {
                    result.append(this.constants.get(trimmedExpr));
                }
                i += expr.length() + 2;
                continue;
            }
            if (c0 == 96 && allowExec) {
                String expr = this.subStr(s, i + 1, 96);
                try {
                    String r = ProcessUtils.execToString(this.evaluateExpressions(expr, false));
                    if (r.charAt(r.length() - 1) == '\n') {
                        result.append(r, 0, r.length() - 1);
                    } else {
                        result.append(r);
                    }
                }
                catch (IOException e) {
                    throw new EoulsanException("Error while evaluating expression \"" + expr + "\"", e);
                }
                i += expr.length() + 1;
                continue;
            }
            result.appendCodePoint(c0);
        }
        return result.toString();
    }

    private String subStr(String s, int beginIndex, int charPoint) throws EoulsanException {
        int endIndex = s.indexOf(charPoint, beginIndex);
        if (endIndex == -1) {
            throw new EoulsanException("Unexpected end of expression in \"" + s + "\"");
        }
        return s.substring(beginIndex, endIndex);
    }

    private String getAttribute(Element eStepElement, String name) throws EoulsanException {
        return this.evaluateExpressions(eStepElement.getAttribute(name), true);
    }

    private static int parseMemory(String s) throws EoulsanException {
        int result;
        if (s == null) {
            return -1;
        }
        String value = s.replace(" ", "").trim().toLowerCase();
        if (s.isEmpty()) {
            return -1;
        }
        Pattern pattern = Pattern.compile("^(\\d+)([a-z]*)$");
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            throw new EoulsanException("Invalid memory value in requiredmemory attribute of tag step: " + s);
        }
        try {
            result = Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException e) {
            throw new EoulsanException("Invalid memory value in requiredmemory attribute of tag step: " + s);
        }
        switch (matcher.group(2)) {
            case "mib": 
            case "mb": 
            case "m": 
            case "": {
                break;
            }
            case "gib": 
            case "gb": 
            case "g": {
                result *= 1024;
                break;
            }
            default: {
                throw new EoulsanException("Invalid memory value in requiredmemory attribute of tag step: " + s);
            }
        }
        return result;
    }

    private static int parseProcessors(String s) throws EoulsanException {
        if (s == null) {
            return -1;
        }
        String value = s.trim();
        if (value.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            throw new EoulsanException("Invalid processor count in requiredprocs attribute of tag step: " + s);
        }
    }

    public CommandWorkflowParser(File file) throws FileNotFoundException {
        this(FileUtils.createInputStream((File)file));
    }

    public CommandWorkflowParser(DataFile file) throws IOException {
        this(file.open());
    }

    public CommandWorkflowParser(InputStream is) {
        this.is = is;
    }

    public static final class StepOutputPort {
        public final String stepId;
        public final String outputPortName;

        public StepOutputPort(String stepId, String outputPortName) {
            this.stepId = stepId == null ? null : stepId.trim();
            this.outputPortName = outputPortName == null ? null : outputPortName.trim();
        }
    }
}

