/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractData;
import fr.ens.biologie.genomique.eoulsan.core.workflow.SimpleDataMetadata;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowFileNaming;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataMetadata;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class DataElement
extends AbstractData
implements Serializable {
    private static final long serialVersionUID = -8982205120365590676L;
    private final DataMetadata metadata;
    protected final List<DataFile> files;
    private final StepOutputPort port;
    private boolean canRename = true;

    @Override
    public void setName(String name) {
        if (!this.canRename) {
            throw new EoulsanRuntimeException("Data cannot be renamed once it has been used");
        }
        super.setName(name);
        this.updateDataFiles();
    }

    @Override
    void setPart(int part) {
        if (!this.canRename) {
            throw new EoulsanRuntimeException("Data cannot be renamed once it has been used");
        }
        super.setPart(part);
        this.updateDataFiles();
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public List<Data> getListElements() {
        return Collections.singletonList(this);
    }

    @Override
    public DataMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Data addDataToList(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Data addDataToList(String name, int part) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDataFilename() {
        return this.getDataFile().getName();
    }

    @Override
    public String getDataFilename(int fileIndex) {
        if (this.getFormat().getMaxFilesCount() < 2) {
            throw new EoulsanRuntimeException("Only multi-files DataFormat are handled by this method.");
        }
        return this.files.get(fileIndex).getName();
    }

    @Override
    public DataFile getDataFile() {
        if (this.getFormat().getMaxFilesCount() > 1) {
            throw new EoulsanRuntimeException("Multi-files DataFormat cannot be handled by this method, use getDataFile(int) instead.");
        }
        this.canRename = false;
        return this.files.get(0);
    }

    void setDataFile(DataFile dataFile) {
        Objects.requireNonNull(dataFile, "DataFile to set cannot be null");
        if (this.files.size() == 0) {
            throw new IllegalStateException("Cannot set a DataFile if not already exists");
        }
        this.files.set(0, dataFile);
    }

    void setDataFile(int fileIndex, DataFile dataFile) {
        Preconditions.checkArgument((fileIndex >= 0 ? 1 : 0) != 0, (Object)"fileIndex argument must be >=0");
        Objects.requireNonNull(dataFile, "DataFile to set cannot be null");
        if (fileIndex >= this.files.size()) {
            throw new IllegalStateException("Cannot set a DataFile if not already exists");
        }
        this.files.set(fileIndex, dataFile);
    }

    void setDataFiles(List<DataFile> dataFiles) {
        Objects.requireNonNull(dataFiles, "dataFiles to set cannot be null");
        for (DataFile file : dataFiles) {
            Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"dataFiles cannot contains null value");
            Preconditions.checkArgument((Collections.frequency(dataFiles, file) == 1 ? 1 : 0) != 0, (Object)("dataFiles cannot contains the same file: " + file));
        }
        this.files.clear();
        this.files.addAll(dataFiles);
    }

    List<DataFile> getDataFiles() {
        return Collections.unmodifiableList(Lists.newArrayList(this.files));
    }

    @Override
    public DataFile getDataFile(int fileIndex) {
        if (this.getFormat().getMaxFilesCount() < 2) {
            throw new EoulsanRuntimeException("Only multi-files DataFormat are handled by this method, use getDataFile() instead.");
        }
        if (fileIndex < 0) {
            throw new EoulsanRuntimeException("File index parameter cannot be lower than 0");
        }
        if (fileIndex > this.files.size()) {
            throw new EoulsanRuntimeException("Cannot create file index " + fileIndex + " as file index " + this.files.size() + " is not created");
        }
        if (fileIndex >= this.getFormat().getMaxFilesCount()) {
            throw new EoulsanRuntimeException("The format " + this.getFormat().getName() + " does not support more than " + this.getFormat().getMaxFilesCount() + " multi-files");
        }
        if (fileIndex == this.files.size()) {
            this.files.add(this.createDataFile(fileIndex));
        }
        return this.files.get(fileIndex);
    }

    @Override
    public int getDataFileCount() {
        return this.files.size();
    }

    @Override
    public int getDataFileCount(boolean existingFiles) {
        return this.files.size();
    }

    private DataFile createDataFile(int fileIndex) {
        return WorkflowFileNaming.file(this.port, this, fileIndex);
    }

    private void updateDataFiles() {
        if (this.port != null) {
            if (this.port.getFormat().getMaxFilesCount() > 1) {
                for (int i = 0; i < this.files.size(); ++i) {
                    this.files.set(i, this.createDataFile(i));
                }
            } else {
                this.files.set(0, this.createDataFile(-1));
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("format", (Object)this.getFormat().getName()).add("metadata", (Object)this.getMetadata()).add("list", this.isList()).add("content", this.files).toString();
    }

    DataElement(DataFormat format, List<DataFile> files, Design design) {
        super(format);
        this.metadata = new SimpleDataMetadata(design);
        Objects.requireNonNull(format, "format argument cannot be null");
        Objects.requireNonNull(files, "files argument cannot be null");
        Objects.requireNonNull(design, "design argument cannot be null");
        for (DataFile f : files) {
            if (f != null) continue;
            throw new IllegalArgumentException("The files list argument cannot contains null elements");
        }
        this.files = Lists.newArrayList(files);
        this.port = null;
    }

    DataElement(DataFormat format, DataFile file, Design design) {
        this(format, Collections.singletonList(file), design);
    }

    DataElement(StepOutputPort port, Design design) {
        super(port.getFormat());
        Objects.requireNonNull(port, "port argument cannot be null");
        Objects.requireNonNull(design, "design argument cannot be null");
        this.metadata = new SimpleDataMetadata(design);
        this.port = port;
        this.files = this.getFormat().getMaxFilesCount() == 1 ? Lists.newArrayList((Object[])new DataFile[]{this.createDataFile(-1)}) : Lists.newArrayList((Object[])new DataFile[]{this.createDataFile(0)});
    }

    DataElement(DataElement data) {
        super(data);
        this.metadata = new SimpleDataMetadata((SimpleDataMetadata)data.metadata);
        this.files = new ArrayList<DataFile>(data.files);
        this.port = data.port;
        this.canRename = true;
    }
}

