/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.core.InputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.CrossDataProduct;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataProduct;
import fr.ens.biologie.genomique.eoulsan.core.workflow.MatchDataProduct;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPorts;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import java.io.Serializable;
import java.util.Set;

class DefaultDataProduct
implements DataProduct,
Serializable {
    private static final long serialVersionUID = -4521747867897781954L;
    private static final String DATAPRODUCT_NAME = "autoconf";
    private DataProduct dataproduct;

    DefaultDataProduct() {
    }

    @Override
    public String getName() {
        return this.dataproduct == null ? DATAPRODUCT_NAME : this.dataproduct.getName();
    }

    @Override
    public void configure(String conf) throws EoulsanException {
        String s;
        Preconditions.checkState((this.dataproduct == null ? 1 : 0) != 0, (Object)"configure() has been already called");
        switch (s = Strings.nullToEmpty((String)conf).trim().toLowerCase()) {
            case "match": {
                this.dataproduct = new MatchDataProduct();
                break;
            }
            case "cross": 
            case "": {
                this.dataproduct = new CrossDataProduct();
                break;
            }
            default: {
                throw new EoulsanException("Unknown data product method: " + conf);
            }
        }
        this.dataproduct.configure(conf);
    }

    @Override
    public Set<ImmutableMap<InputPort, Data>> makeProduct(StepInputPorts inputPorts, Multimap<InputPort, Data> inputTokens) {
        Preconditions.checkState((this.dataproduct != null ? 1 : 0) != 0, (Object)"configure() has not been called");
        return this.dataproduct.makeProduct(inputPorts, inputTokens);
    }
}

