/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Workflow;
import fr.ens.biologie.genomique.eoulsan.core.workflow.CommandWorkflow;
import fr.ens.biologie.genomique.eoulsan.core.workflow.CommandWorkflowModel;
import fr.ens.biologie.genomique.eoulsan.core.workflow.CommandWorkflowParser;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ExecutorArguments;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepObserverRegistry;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.io.DefaultDesignReader;
import fr.ens.biologie.genomique.eoulsan.ui.UI;
import fr.ens.biologie.genomique.eoulsan.ui.UIService;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopInfo;
import fr.ens.biologie.genomique.kenetre.util.SystemUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Executor {
    private final ExecutorArguments arguments;
    private final CommandWorkflowModel command;
    private final Design design;

    private void checkDesign() throws EoulsanException {
        if (this.design == null) {
            throw new EoulsanException("The design is null");
        }
        if (this.design.getSamples().isEmpty()) {
            throw new EoulsanException("Nothing to do, no samples found in design file");
        }
        EoulsanLogger.getLogger().info("Found " + this.design.getSamples().size() + " sample(s) in design file");
    }

    public void execute() throws EoulsanException {
        this.execute(null, null);
    }

    public void execute(List<Module> firstSteps, List<Module> lastSteps) throws EoulsanException {
        Executor.logInfo(this.arguments, this.command);
        if (EoulsanRuntime.getRuntime().getMode().isHadoopMode()) {
            HadoopInfo.logHadoopSysInfo();
        }
        if (this.arguments.getLocalWorkingPathname() == null) {
            throw new EoulsanException("The base path is null");
        }
        this.checkDesign();
        Settings settings = EoulsanRuntime.getSettings();
        Executor.updateSettingsWithGlobalParameters(settings, this.command);
        Executor.configureEoulsanTools(settings);
        CommandWorkflow workflow = new CommandWorkflow(this.arguments, this.command, firstSteps, lastSteps, this.design);
        workflow.checkDirectories();
        UI ui = this.startUI(workflow);
        StepObserverRegistry.getInstance().addObserver(ui);
        EoulsanLogger.getLogger().info("Start analysis at " + new Date(System.currentTimeMillis()));
        workflow.execute();
    }

    private UI startUI(Workflow workflow) throws EoulsanException {
        String uiName = EoulsanRuntime.getSettings().getUIName();
        if (uiName == null) {
            throw new EoulsanException("No UI name defined.");
        }
        UIService uiService = UIService.getInstance();
        if (!uiService.isService(uiName)) {
            throw new EoulsanException("Unknown UI name: " + uiName);
        }
        UI ui = (UI)uiService.newService(uiName);
        ui.init(workflow);
        return ui;
    }

    private static void logInfo(ExecutorArguments execArgs, CommandWorkflowModel command) {
        EoulsanLogger.getLogger().info("Design file path: " + execArgs.getDesignPathname());
        EoulsanLogger.getLogger().info("Workflow file path: " + execArgs.getWorkflowPathname());
        EoulsanLogger.getLogger().info("Workflow Author: " + command.getAuthor());
        EoulsanLogger.getLogger().info("Workflow Description: " + command.getDescription());
        EoulsanLogger.getLogger().info("Workflow Name: " + command.getName());
        EoulsanLogger.getLogger().info("Job Id: " + execArgs.getJobId());
        EoulsanLogger.getLogger().info("Job UUID: " + execArgs.getJobUUID());
        EoulsanLogger.getLogger().info("Job Description: " + execArgs.getJobDescription());
        EoulsanLogger.getLogger().info("Job Environment: " + execArgs.getJobEnvironment());
        EoulsanLogger.getLogger().info("Job Base path: " + execArgs.getLocalWorkingPathname());
        EoulsanLogger.getLogger().info("Job Output path: " + execArgs.getOutputPathname());
        EoulsanLogger.getLogger().info("Job Log path: " + execArgs.getJobPathname());
    }

    private static Design loadDesign(ExecutorArguments arguments) throws EoulsanException {
        try {
            EoulsanLogger.getLogger().info("Read design file");
            InputStream is = arguments.openDesignFile();
            Objects.requireNonNull(is, "The input stream for design file is null");
            return new DefaultDesignReader(is).read();
        }
        catch (IOException e) {
            throw new EoulsanException("Error while reading design file: " + e.getMessage(), e);
        }
    }

    private static CommandWorkflowModel loadCommand(ExecutorArguments arguments, Design design) throws EoulsanException {
        try {
            InputStream is = arguments.openParamFile();
            Objects.requireNonNull(is, "The input stream for workflow file is null");
            CommandWorkflowParser pp = new CommandWorkflowParser(is);
            pp.addConstants(arguments);
            for (Map.Entry<String, String> e : design.getMetadata().entrySet()) {
                pp.addConstant("design.header." + e.getKey(), e.getValue());
            }
            return pp.parse();
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
    }

    private static void updateSettingsWithGlobalParameters(Settings settings, CommandWorkflowModel command) {
        Set<Parameter> globalParameters = command.getGlobalParameters();
        EoulsanLogger.getLogger().info("Init all steps with global parameters: " + globalParameters);
        for (Parameter p : globalParameters) {
            settings.setSetting(p.getName(), p.getStringValue());
        }
    }

    private static void configureEoulsanTools(Settings settings) {
        if (!settings.isUseStandardExternalModules()) {
            return;
        }
        if (SystemUtils.isActiveConnection((String)"raw.githubusercontent.com", (int)443, (int)5000)) {
            Object branch = "master";
            if (Globals.APP_VERSION.getMajor() > 1) {
                branch = "branch" + Globals.APP_VERSION.getMajor() + "." + Globals.APP_VERSION.getMinor();
            }
            String defaultGalaxyToolPath = "https://raw.githubusercontent.com/GenomicParisCentre/eoulsan-tools/" + (String)branch + "/galaxytools";
            String defaultDataFormatPath = "https://raw.githubusercontent.com/GenomicParisCentre/eoulsan-tools/" + (String)branch + "/formats";
            ArrayList<String> galaxyToolPathList = new ArrayList<String>(settings.getGalaxyToolPaths());
            galaxyToolPathList.add(defaultGalaxyToolPath);
            settings.setGalaxyToolsPaths(galaxyToolPathList);
            ArrayList<String> dataFormatPathList = new ArrayList<String>(settings.getDataFormatPaths());
            dataFormatPathList.add(defaultDataFormatPath);
            settings.setDataFormatPaths(dataFormatPathList);
        }
    }

    public Executor(ExecutorArguments arguments) throws EoulsanException {
        Objects.requireNonNull(arguments, "The arguments of the executor is null");
        this.arguments = arguments;
        this.design = Executor.loadDesign(arguments);
        this.command = Executor.loadCommand(arguments, this.design);
    }
}

