/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Strings;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.annotations.ExecutionMode;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ModuleService;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.modules.GalaxyToolModule;
import fr.ens.biologie.genomique.eoulsan.util.ClassPathResourceLoader;
import fr.ens.biologie.genomique.eoulsan.util.FileResourceLoader;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ModuleRegistry {
    private static final String RESOURCE_PREFIX = "META-INF/services/registrytoolshed/";
    private static final String GALAXY_TOOL_SUBDIR = "galaxytools";
    private static ModuleRegistry instance;
    private final ModuleService service;
    private final GalaxyToolModuleClassPathLoader galaxyClassPathLoader;
    private final GalaxyToolModuleFileResourceLoader galaxyFileLoader;
    private final Set<String> javaModuleFound = new LinkedHashSet<String>();

    public static synchronized ModuleRegistry getInstance() {
        if (instance == null) {
            instance = new ModuleRegistry();
            instance.reload();
        }
        return instance;
    }

    public Module loadModule(String moduleName, String version) {
        ArrayList<Module> modulesFound = new ArrayList<Module>();
        modulesFound.addAll(this.service.newServices(moduleName));
        modulesFound.addAll(this.galaxyClassPathLoader.loadResources(moduleName));
        modulesFound.addAll(this.galaxyFileLoader.loadResources(moduleName));
        this.filterModules(modulesFound, Strings.nullToEmpty((String)version).trim());
        this.sortModules(modulesFound);
        if (modulesFound.isEmpty()) {
            return null;
        }
        return (Module)modulesFound.get(modulesFound.size() - 1);
    }

    public void reload() {
        this.service.reload();
        this.galaxyClassPathLoader.reload();
        this.galaxyFileLoader.reload();
        this.javaModuleFound.clear();
        for (Map.Entry e : this.service.getServiceClasses().entries()) {
            this.javaModuleFound.add((String)e.getKey());
            EoulsanLogger.getLogger().config("Found module: " + (String)e.getKey() + " (" + (String)e.getValue() + ")");
        }
        ArrayList modulesFound = new ArrayList();
        modulesFound.addAll(this.galaxyClassPathLoader.loadAllResources());
        modulesFound.addAll(this.galaxyFileLoader.loadAllResources());
        for (GalaxyToolModule s : modulesFound) {
            EoulsanLogger.getLogger().config("Found module: " + s.getName() + " (Galaxy tool, source: " + s.getSource() + ")");
        }
    }

    public List<Module> getAllModules() {
        ArrayList<Module> result = new ArrayList<Module>();
        for (String moduleName : this.javaModuleFound) {
            result.addAll(this.service.newServices(moduleName));
        }
        result.addAll(this.galaxyClassPathLoader.loadAllResources());
        result.addAll(this.galaxyFileLoader.loadAllResources());
        return result;
    }

    private void filterModules(List<Module> modules, String version) {
        if (modules == null || "".equals(version)) {
            return;
        }
        ArrayList<Module> toRemove = new ArrayList<Module>();
        for (Module module : modules) {
            Version moduleVersion = module.getVersion();
            if (moduleVersion == null || moduleVersion.toString().equals(version)) continue;
            toRemove.add(module);
        }
        modules.removeAll(toRemove);
    }

    private void sortModules(List<Module> modules) {
        if (modules == null) {
            return;
        }
        Collections.reverse(modules);
        modules.sort(new Comparator<Module>(){

            @Override
            public int compare(Module m1, Module m2) {
                if (m1 == null) {
                    return 1;
                }
                if (m2 == null) {
                    return -1;
                }
                int result = this.compareModuleModes(m1, m2);
                if (result != 0) {
                    return result;
                }
                return this.compareModuleVersions(m1, m2);
            }

            private int compareModuleModes(Module m1, Module m2) {
                ExecutionMode mode2;
                ExecutionMode mode1 = ExecutionMode.getExecutionMode(m1.getClass());
                int result = this.compareModes(mode1, mode2 = ExecutionMode.getExecutionMode(m2.getClass()), ExecutionMode.HADOOP_ONLY);
                if (result != 0) {
                    return result;
                }
                result = this.compareModes(mode1, mode2, ExecutionMode.HADOOP_COMPATIBLE);
                if (result != 0) {
                    return result;
                }
                return this.compareModes(mode1, mode2, ExecutionMode.LOCAL_ONLY);
            }

            private int compareModes(ExecutionMode mode1, ExecutionMode mode2, ExecutionMode modeToCompare) {
                if (mode1 == modeToCompare && mode2 != modeToCompare) {
                    return 1;
                }
                if (mode2 == modeToCompare && mode1 != modeToCompare) {
                    return -1;
                }
                return 0;
            }

            private int compareModuleVersions(Module s1, Module s2) {
                Version v1 = s1.getVersion();
                Version v2 = s2.getVersion();
                if (v1 == null) {
                    return 1;
                }
                if (v2 == null) {
                    return -1;
                }
                return v1.compareTo(v2);
            }
        });
    }

    private ModuleRegistry() {
        this.service = new ModuleService();
        this.galaxyClassPathLoader = new GalaxyToolModuleClassPathLoader();
        this.galaxyFileLoader = new GalaxyToolModuleFileResourceLoader(EoulsanRuntime.getSettings().getGalaxyToolPaths());
    }

    private static final class GalaxyToolModuleClassPathLoader
    extends ClassPathResourceLoader<GalaxyToolModule> {
        @Override
        protected GalaxyToolModule load(InputStream in, String source) throws IOException, EoulsanException {
            return new GalaxyToolModule(in, source);
        }

        @Override
        protected String getResourceName(GalaxyToolModule resource) {
            Objects.requireNonNull(resource, "resource argument cannot be null");
            return resource.getName();
        }

        public GalaxyToolModuleClassPathLoader() {
            super(GalaxyToolModule.class, ModuleRegistry.RESOURCE_PREFIX);
        }
    }

    private static final class GalaxyToolModuleFileResourceLoader
    extends FileResourceLoader<GalaxyToolModule> {
        @Override
        protected String getExtension() {
            return ".xml";
        }

        @Override
        protected GalaxyToolModule load(InputStream in, String source) throws IOException, EoulsanException {
            Objects.requireNonNull(in, "in argument cannot be null");
            try {
                return new GalaxyToolModule(in, source);
            }
            catch (EoulsanException e) {
                throw new EoulsanException("Unable to load Galaxy tool module: " + source, e);
            }
        }

        private static DataFile getDefaultFormatDirectory() {
            Main main = Main.getInstance();
            if (main == null) {
                return new DataFile(ModuleRegistry.GALAXY_TOOL_SUBDIR);
            }
            return new DataFile(new File(main.getEoulsanDirectory(), ModuleRegistry.GALAXY_TOOL_SUBDIR));
        }

        @Override
        protected String getResourceName(GalaxyToolModule resource) {
            Objects.requireNonNull(resource, "resource argument cannot be null");
            return resource.getName();
        }

        public GalaxyToolModuleFileResourceLoader(List<String> resourcePaths) {
            super(GalaxyToolModule.class, GalaxyToolModuleFileResourceLoader.getDefaultFormatDirectory());
            if (resourcePaths != null) {
                this.addResourcePaths(resourcePaths);
            }
        }
    }
}

