/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.core.AbstractPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPort;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPort;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class StepInputPorts
extends AbstractPorts<StepInputPort>
implements Serializable {
    private static final long serialVersionUID = -746211786359434112L;

    public Set<AbstractStep> getLinkedSteps() {
        HashSet<AbstractStep> result = new HashSet<AbstractStep>();
        for (StepInputPort sip : this) {
            result.add(sip.getLink().getStep());
        }
        return Collections.unmodifiableSet(result);
    }

    static StepInputPorts noInputPort() {
        Set<StepInputPort> ports = Collections.emptySet();
        return new StepInputPorts(ports);
    }

    private static Set<StepInputPort> convert(AbstractStep step, InputPorts ports) {
        if (ports == null) {
            throw new NullPointerException("Ports is null");
        }
        boolean hadoopMode = EoulsanRuntime.getRuntime().getMode().isHadoopMode() && step.getEoulsanMode().isHadoopCompatible();
        HashSet<StepInputPort> result = new HashSet<StepInputPort>();
        for (InputPort port : ports) {
            if (port == null) continue;
            result.add(new StepInputPort(step, port.getName(), port.isList(), port.getFormat(), port.getCompressionsAccepted(), hadoopMode ? true : port.isRequiredInWorkingDirectory()));
        }
        return result;
    }

    StepInputPorts(Set<StepInputPort> ports) {
        super(ports);
    }

    StepInputPorts(AbstractStep step, InputPorts ports) {
        super(StepInputPorts.convert(step, ports));
    }
}

