/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ModuleRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class StepInstances {
    private static StepInstances instance;
    private final Map<Step, Module> steps = new HashMap<Step, Module>();

    public Module getModule(Step step) {
        Objects.requireNonNull(step, "Step is null");
        String stepName = step.getModuleName();
        String stepVersion = step.getStepVersion();
        try {
            return this.getModule(step, stepName, stepVersion);
        }
        catch (EoulsanException e) {
            throw new EoulsanRuntimeException(e);
        }
    }

    public Module getModule(Step step, String moduleName, String moduleVersion) throws EoulsanException {
        Objects.requireNonNull(moduleName, "Step name is null");
        if (!this.steps.containsKey(step)) {
            Module moduleInstance = StepInstances.loadModule(moduleName, moduleVersion);
            this.registerStep(step, moduleInstance);
            return moduleInstance;
        }
        return this.steps.get(step);
    }

    public void registerStep(Step step, Module module) {
        Objects.requireNonNull(step, "workflow step is null");
        Objects.requireNonNull(module, "module is null");
        this.steps.put(step, module);
    }

    public void removeStep(Step step) {
        Objects.requireNonNull(step);
        this.steps.remove(step);
    }

    public static StepInstances getInstance() {
        if (instance == null) {
            instance = new StepInstances();
        }
        return instance;
    }

    private static Module loadModule(String moduleName, String moduleVersion) throws EoulsanException {
        if (moduleName == null) {
            throw new EoulsanException("Step name is null");
        }
        String lower = moduleName.trim().toLowerCase();
        Module result = ModuleRegistry.getInstance().loadModule(lower, moduleVersion);
        if (result == null) {
            throw new EoulsanException("Unknown module: " + lower + (String)("".equals(moduleVersion) ? "" : " (version required: " + moduleVersion + ")"));
        }
        return result;
    }

    private StepInstances() {
    }
}

