/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.eventbus.Subscribe;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepObserver;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepStateEvent;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UIStepEvent;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UITaskEvent;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UIWorkflowEvent;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowEventBus;
import java.util.HashSet;
import java.util.Set;

public class StepObserverRegistry {
    private static StepObserverRegistry singleton;
    private final Set<StepObserver> observers = new HashSet<StepObserver>();

    public void addObserver(StepObserver observer) {
        if (observer == null || this.observers.contains(observer)) {
            return;
        }
        this.observers.add(observer);
    }

    public void removeObserver(StepObserver observer) {
        if (observer == null) {
            return;
        }
        this.observers.remove(observer);
    }

    public boolean isNoObserverRegistered() {
        return this.observers.isEmpty();
    }

    @Subscribe
    public void uiTaskEvent(UITaskEvent event) {
        if (event == null) {
            return;
        }
        Step step = event.getStep();
        int contextId = event.getContextId();
        switch (event.getTaskStatusMessage()) {
            case SUBMITTED: {
                for (StepObserver o : this.observers) {
                    o.notifyTaskSubmitted(step, contextId);
                }
                break;
            }
            case RUNNING: {
                for (StepObserver o : this.observers) {
                    o.notifyTaskRunning(step, contextId);
                }
                break;
            }
            case DONE: {
                for (StepObserver o : this.observers) {
                    o.notifyTaskDone(step, contextId);
                }
                break;
            }
        }
    }

    @Subscribe
    public void stepStateEvent(StepStateEvent event) {
        if (event == null) {
            return;
        }
        for (StepObserver o : this.observers) {
            o.notifyStepState((Step)event.getStep(), event.getState());
        }
    }

    @Subscribe
    public void uiStepEvent(UIStepEvent event) {
        if (event == null) {
            return;
        }
        Step step = event.getStep();
        double progress = event.getProgress();
        switch (event.getStatus()) {
            case PROGRESS: {
                int contextId = event.getContextId();
                String contextName = event.getContextName();
                for (StepObserver o : this.observers) {
                    o.notifyStepState(step, contextId, contextName, progress);
                }
                break;
            }
            case TASK_PROGRESS: {
                int terminatedTasks = event.getTerminatedTasks();
                int submittedTasks = event.getSubmittedTasks();
                for (StepObserver o : this.observers) {
                    o.notifyStepState(step, terminatedTasks, submittedTasks, progress);
                }
                break;
            }
            case NOTE: {
                String note = event.getNote();
                for (StepObserver o : this.observers) {
                    o.notifyStepState(step, note);
                }
                break;
            }
        }
    }

    @Subscribe
    public void uiWorkflowEvent(UIWorkflowEvent event) {
        if (event == null) {
            return;
        }
        for (StepObserver o : this.observers) {
            o.notifyWorkflowSuccess(event.isSuccess(), event.getMessage());
        }
    }

    public static StepObserverRegistry getInstance() {
        if (singleton == null) {
            singleton = new StepObserverRegistry();
        }
        return singleton;
    }

    private StepObserverRegistry() {
        WorkflowEventBus.getInstance().register(this);
    }
}

