/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.core.AbstractPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPort;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class StepOutputPorts
extends AbstractPorts<StepOutputPort>
implements Serializable {
    private static final long serialVersionUID = 183816706502235237L;

    public Set<AbstractStep> getLinkedSteps() {
        HashSet<AbstractStep> result = new HashSet<AbstractStep>();
        for (StepOutputPort sop : this) {
            for (StepInputPort sip : sop.getLinks()) {
                result.add(sip.getStep());
            }
        }
        return Collections.unmodifiableSet(result);
    }

    static StepOutputPorts noOutputPort() {
        Set<StepOutputPort> ports = Collections.emptySet();
        return new StepOutputPorts(ports);
    }

    private static Set<StepOutputPort> convert(AbstractStep step, OutputPorts ports) {
        if (ports == null) {
            throw new NullPointerException("Ports is null");
        }
        HashSet<StepOutputPort> result = new HashSet<StepOutputPort>();
        for (OutputPort port : ports) {
            if (port == null) continue;
            result.add(new StepOutputPort(step, port.getName(), port.isList(), port.getFormat(), port.getCompression()));
        }
        return result;
    }

    StepOutputPorts(Set<StepOutputPort> ports) {
        super(ports);
    }

    StepOutputPorts(AbstractStep step, OutputPorts ports) {
        super(StepOutputPorts.convert(step, ports));
    }
}

